unit ptkmainform;

//  VL:
// Copyright (C) 2013  . .

//  

interface

uses
 Windows,SysUtils,Classes,Controls,Forms,Dialogs,StdCtrls,ExtCtrls;

type
 TPTK_MainForm = class (TForm)
                  Label1             : TLabel;
                  Version_Label      : TLabel;
                  Label2             : TLabel;
                  QueryName_Edit     : TLabeledEdit;
                  ISPath_Edit        : TLabeledEdit;
                  Name_Edit          : TLabeledEdit;
                  RegNums_Edit       : TLabeledEdit;
                  BrowseQuery_Button : TButton;
                  BrowseIS_Button    : TButton;
                  Start_Button       : TButton;
                  SubDirs_CheckBox   : TCheckBox;
                  Debug_Label        : TLabel;
                  Query_OpenDialog   : TOpenDialog;
                  GetNameNums_Button : TButton;
                  Format_Group       : TRadioGroup;
                  procedure BrowseQuery_ButtonClick (Sender: TObject);
                  procedure BrowseIS_ButtonClick (Sender: TObject);
                  procedure OnShow (Sender: TObject);
                  procedure Start_ButtonClick (Sender: TObject);
                  procedure GetNameNums_ButtonClick (Sender: TObject);
                 private
                 { Private declarations }
                 public
                 { Public declarations }
                 end;

var
 PTK_MainForm: TPTK_MainForm;

implementation

{$R *.dfm}

uses dirselect,sverkaptk,ptkconstants,ShellAPI;

procedure TPTK_MainForm.BrowseIS_ButtonClick (Sender: TObject);
var
 s       : string;
 sFolder : string;
begin
 if sFolder='' then sFolder := ISPath_Edit.Text;
 s := SelFolder (Handle,sFolder);
 if s <> '' then ISPath_Edit.Text := s;
end;

procedure TPTK_MainForm.BrowseQuery_ButtonClick (Sender: TObject);
begin
 if Query_OpenDialog.Execute then QueryName_Edit.Text := Query_OpenDialog.FileName;
end;

// "  "
procedure TPTK_MainForm.GetNameNums_ButtonClick(Sender: TObject);
var
 App : TPTKSverkaApp;
begin
 //   
 App := TPTKSverkaApp.Create;
 //  
 App.ISPath := ISPath_Edit.Text;
 // 
 if not App.GetReqs
  then MessageBox (Handle,PChar (string (App.ErrorMsg)),'',mb_IconError)
  else begin
        Name_Edit.Text := App.StrName;
        RegNums_Edit.Text := App.RegNums;
       end;
 //   
 App.Destroy;
end;

procedure TPTK_MainForm.OnShow(Sender: TObject);
begin
 Version_Label.Caption := Version;
 Debug_Label.Visible := DebugBuild;
 ISPath_Edit.Text := ExtractFilePath (Application.ExeName);
end;

procedure TPTK_MainForm.Start_ButtonClick (Sender: TObject);
var
 App : TPTKSverkaApp;
begin
 //   
 App := TPTKSverkaApp.Create;
 //  
 App.PTKFileName := QueryName_Edit.Text;
 App.StrName := Name_Edit.Text;
 App.RegNums := RegNums_Edit.Text;
 App.ISPath := ISPath_Edit.Text;
 App.SubDirs := SubDirs_Checkbox.Checked;
 if Format_Group.ItemIndex=0 then App.ProtFileName := GetEnvironmentVariable ('TEMP')+'\'+RegNums_Edit.Text+'.html'
 else App.ProtFileName := GetEnvironmentVariable ('TEMP')+'\'+RegNums_Edit.Text+'.xml';
 App.ProtFormat := Format_Group.ItemIndex;
 // 
 if not App.Start
  then MessageBox (Handle,PChar (string (App.ErrorMsg)),'',mb_IconError)
  else if App.ProtFormat = 0
   then ShellExecute (0,'open',PChar (string (App.ProtFileName)),'','',sw_maximize)
   else ShellExecute (0,'open','excel.exe',PChar (string (App.ProtFileName)),'',sw_maximize);
 //   
 App.Destroy;
end;

end.
