unit protptk;

//  VL:
// Copyright (C) 2013  . .

//    

interface

type


 //       
 TPTKProtFileRec = record
                    FileName : ANSIString;     //  
                    FormType : ANSIString;     //  
                    OtYear   : integer;        //  
                    OtPer    : integer;        //  
                    CatCode  : ANSIString;     //    
                    DogType  : ANSIString;     //  
                   end;

 //        
 TPTKProtMainRec = record
                    SNILS           : string [11];     //  ( )
                    FIO             : string [150];    //   
                    QueryNumber     : integer;         //  /   
                    QueryLastPer    : ANSIString;      //       
                    QueryLastPerErr : Boolean;         //        -  
                    FileNumber      : ANSIString;      //        
                    SSExists        : Boolean;         //     -      
                    SSS             : Currency;        //       
                    SSSErr          : Boolean;         //        -  
                    CExists         : Boolean;         // / -   . 
                    CNS             : Currency;        //    
                    CUS             : Currency;        //    
                    ESS             : Currency;        //     
                    ESSErr          : integer;         //      -  
                    SSN             : Currency;        //       
                    SSNErr          : Boolean;         //        -  
                    CNN             : Currency;        //    
                    CUN             : Currency;        //    
                    ESN             : Currency;        //     
                    ESNErr          : integer;         //      -  
                   end;

 TPTKProt = class
             ProgLink    : ANSIString;               //   
             ProgVersion : ANSIString;               //  
             DebugBuild  : Boolean;                  //   
             BriefName   : ANSIString;               //  
             RegNumb     : ANSIString;               //  
             CalcYear    : integer;                  //   
             CalcPer     : integer;                  //   
             PFRFileName : ANSIString;               //     
             PFRFileType : ANSIString;               //   
             PFRFileDate : ANSIString;               // ,      
             PFRFilePer  : ANSIString;               //      
             constructor Create;
             destructor Destroy;
            private
             Files       : array of TPTKProtFileRec; //    . 
             Recs        : array of TPTKProtMainRec; //  
             procedure Clear;
             function RecIndex (SNILS,FIO : ANSIString) : integer;
            public
             procedure AddFile (FileName,FormType : ANSIString; OtYear,OtPer : integer; DogType,CatCode : ANSIString);
             procedure AddPTKSved (NPP : integer; SNILS,FIO : ANSIString; LastYear,LastPer : integer; SS,SN : Currency);
             procedure AddISSved (PackNumb,NumInPack : integer; SNILS,FIO : ANSIString; NS,US,NN,UN : Currency);
             procedure CalcItogs;
             procedure Sort;
             procedure makeHTML (FileName : ANSIString);
             procedure MakeExcel (FileName : ANSIString);
            end;

implementation

uses SysUtils,funcs;

//   TPTKProt

constructor TPTKProt.Create;
begin
 Clear;
end;

destructor TPTKProt.Destroy;
begin
 Clear;
 inherited Destroy;
end;

//   
procedure TPTKProt.Clear;
begin
 SetLength (Files,0);
 SetLength (Recs,0);
end;

// ,     ;   ,  ,     
function TPTKProt.RecIndex (SNILS,FIO : ANSIString) : integer;
var
 i : integer;
begin
 Result := -1;
 if Length (Recs) > 0
  then for i := 0 to Length (Recs) - 1
   do if Recs [i].SNILS = SNILS
    then begin
          Result := i;
          Recs [Result].FIO := FIO;
          Break;
         end;
 if Result = -1
  then begin
        SetLength (Recs,Length (Recs) + 1);
        Result := Length (Recs) - 1;
        Recs [Result].SNILS := SNILS;
        Recs [Result].FIO := FIO;
        with Recs [Result]
         do begin
             QueryNumber := 0;
             QueryLastPer := '-';
             QueryLastPerErr := False;
             FileNumber := '-';
             SSExists := False;
             CExists := False;
             SSS := 0;
             SSSErr := False;
             CNS := 0;
             CUS := 0;
             ESS := 0;
             ESSErr := 0;
             SSN := 0;
             SSNErr := False;
             CNN := 0;
             CUN := 0;
             ESN := 0;
             ESNErr := 0;
            end;
       end;
end;

//      
procedure TPTKProt.AddFile (FileName: AnsiString; FormType: AnsiString; OtYear: Integer; OtPer: Integer; DogType,CatCode: AnsiString);
begin
 SetLength (Files,Length (Files) + 1);
 Files [Length (Files) - 1].FileName := FileName;
 Files [Length (Files) - 1].FormType := FormType;
 Files [Length (Files) - 1].OtYear := OtYear;
 Files [Length (Files) - 1].OtPer := OtPer;
 Files [Length (Files) - 1].DogType := DogType;
 Files [Length (Files) - 1].CatCode := CatCode;
end;

//    
procedure TPTKProt.AddPTKSved (NPP: Integer; SNILS: AnsiString; FIO: AnsiString; LastYear,LastPer : integer; SS: Currency; SN: Currency);
var
 i : integer;
begin
 i := RecIndex (SNILS,FIO);
 Recs [i].QueryNumber := NPP;
 Recs [i].QueryLastPer := strPeriod (LastYear,LastPer);
 Recs [i].QueryLastPerErr := IsPeriod1Less (LastYear,LastPer,CalcYear,CalcPer);
 Recs [i].SSExists := True;
 Recs [i].SSS := 0 - SS;
 Recs [i].SSSErr := (SS > 0);
 Recs [i].SSN := 0 - SN;
 Recs [i].SSNErr := (SN > 0);
end;

//    
procedure TPTKProt.AddISSved (PackNumb: Integer; NumInPack: Integer; SNILS: AnsiString; FIO: AnsiString; NS: Currency; US: Currency; NN: Currency; UN: Currency);
var
 i : integer;
begin
 // .       ,    ,    ,  
 i := RecIndex (SNILS,FIO);
 if Recs [i].FileNumber <> ''
  then if Recs [i].FileNumber = '-' then Recs [i].FileNumber := '' else Recs [i].FileNumber := Recs [i].FileNumber + ',';
 Recs [i].FileNumber := Recs [i].FileNumber + IntToStr (PackNumb)+'/'+IntToStr (NumInPack);
 Recs [i].CExists := True;
 Recs [i].CNS := Recs [i].CNS + NS;
 Recs [i].CUS := Recs [i].CUS + US;
 Recs [i].CNN := Recs [i].CNN + NN;
 Recs [i].CUN := Recs [i].CUN + UN;
end;

//      
procedure TPTKProt.CalcItogs;
var
 i : integer;
begin
 if Length (Recs) > 0
  then for i := 0 to Length (Recs) - 1
   do with Recs [i]
    do begin
        ESS := SSS + CNS - CUS;
        if ESS < 0 then ESSErr := 2
        else if (ESS > 0) and not CExists then ESSErr := 1;
        ESN := SSN + CNN - CUN;
        if ESN < 0 then ESNErr := 2
        else if (ESN > 0) and not CExists then ESNErr := 1;
       end;
end;

//     
procedure TPTKProt.Sort;
var
 i   : integer;
 Rec : TPTKProtMainRec;
 b   : Boolean;
begin
 if Length (Recs) > 1
  then repeat
        b := False;
        for i := 0 to Length (Recs) - 2
         do if Recs [i].FIO > Recs [i+1].FIO
          then begin
                b := True;
                Rec := Recs [i];
                Recs [i] := Recs [i+1];
                Recs [i+1] := Rec;
               end;
       until b = False;
end;

procedure TPTKProt.makeHTML (FileName: AnsiString);
var
 f                   : TextFile;
 i,i1,i2             : integer;
 PackIndex           : string;
 s                   : string;
 Comment             : string;
begin
 //  
 AssignFile (f,FileName);
 rewrite (f);
 //  
 writeln (f,'<html>');
 writeln (f,' <head>');
 writeln (f,'  <meta http-equiv="Content-Type" content="text/html;charset=windows-1251">');
 writeln (f,'  <title>'+BriefName+' -         </title>');
 writeln (f,'  <script type="text/javascript">');
 writeln (f,'  <!--');
 writeln (f,'  function toggleFilelist()');
 writeln (f,'   {');
 writeln (f,'    if (document.getElementById ("filelist").style.display == "")');
 writeln (f,'     {');
 writeln (f,'      document.getElementById ("filelist").style.display = "none";');
 writeln (f,'      document.getElementById ("filespan").innerHTML = "";');
 writeln (f,'     }');
 writeln (f,'    else');
 writeln (f,'     {');
 writeln (f,'      document.getElementById ("filelist").style.display = "";');
 writeln (f,'      document.getElementById ("filespan").innerHTML = "";');
 writeln (f,'     }');
 writeln (f,'    // return false;');
 writeln (f,'   }');
 writeln (f,'  // -->');
 writeln (f,'  </script>');
 writeln (f,'  <style type="text/css">');
 writeln (f,'   #ta td');
 writeln (f,'    {');
 writeln (f,'     border: 1px solid black;');
 writeln (f,'     font-family: Arial;');
 writeln (f,'     text-align: center;');
 writeln (f,'     font-size: 10pt;');
 writeln (f,'     vertical-align: center;');
 writeln (f,'    }');
 writeln (f,'   .error');
 writeln (f,'    {');
 writeln (f,'     color: red;');
 writeln (f,'    }');
 writeln (f,'  </style>');
 writeln (f,' </head>');
 writeln (f,' <body>');
 //  
 writeln (f,'  <h2>         </h2>');
 write (f,'  <p> <a href="'+ProgLink+'" target="_blank">VL:</a><br/>'+ProgVersion);
 if DebugBuild then write (f,'<br/><font color="#FF0000"><b>   </b></font>');
 writeln (f,'</p>');
 writeln (f,'  <h3>  :</h3>');
 writeln (f,'  <p> : '+BriefName+'</p>');
 writeln (f,'  <p>   : '+RegNumb+'</p>');
 writeln (f,'  <p>    : '+DateToStr (Date)+' '+TimeToStr (Time)+'</p>');
 writeln (f,'  <h3>   :</h3>');
 //      
 writeln (f,'  <p>   : '+PFRFileName+' ,  '+PFRFileType+'    '+PFRFileDate+'</p>');
 writeln (f,'  <p>      : '+PFRFilePer+'</p>');
 //   
 writeln (f,'<p>    :</p>');
 writeln (f,'  <ul>');
 for i := 0 to Length (Files) - 1
  do with Files [i]
   do begin
       write (f,'<li>'+FileName+' - '+FormType+'  '+ strPeriod (OtYear,OtPer));
       write (f,',  '+CatCode);
       if FormType = '-6-4' then write (f,', '+DogType+' ');
       writeln (f,'</li>');
      end;
 writeln (f,'  </ul>');
 // 
 writeln (f,'   <h3> :</h3>');
 writeln (f,'   <table cellpadding="0" cellspacing="0" id="ta">');
 // 2  
 writeln (f,'    <tr>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2> /</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2></td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp;, , &nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp; /  &nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp;<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp; /  &nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" colspan="4"> </td>');
 writeln (f,'     <td style="font-weight: bold" colspan="4"> </td>');
 writeln (f,'     <td style="font-weight: bold" colspan="3"></td>');
 writeln (f,'    </tr>');
 writeln (f,'    <tr>');
 writeln (f,'     <td style="font-weight: bold">&nbsp; <br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp; <br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;.<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'    </tr>');
 //    
 for i := 0 to Length (Recs) - 1
  do begin
      writeln (f,'    <tr>');
      writeln (f,'     <td style="text-align: right">'+IntToStr (i+1)+'</td>');
      writeln (f,'     <td>'+strForHTML (NumberToSNILS (Recs [i].SNILS))+'</td>');
      writeln (f,'     <td style="text-align: left">'+strForHTML (Recs [i].FIO)+'</td>');
      write (f,'     <td>');
      if Recs [i].SSExists then write (f,Recs [i].QueryNumber) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].SSExists then if Recs [i].QueryLastPerErr then write (f,' class="error"');
      write (f,'>');
      if Recs [i].SSExists then write (f,strForHTML (Recs [i].QueryLastPer)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,Recs [i].FileNumber) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].SSExists then if Recs [i].SSSErr then write (f,' class="error"');
      write (f,'>');
      if Recs [i].SSExists then write (f,f2s (Recs [i].SSS)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CNS)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CUS)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].ESSErr <> 0 then write (f,' class="error"');
      writeln (f,'>'+f2s (Recs [i].ESS) +'</td>');
      write (f,'     <td');
      if Recs [i].SSExists then if Recs [i].SSNErr then write (f,' class="error"');
      write (f,'>');
      if Recs [i].SSExists then write (f,f2s (Recs [i].SSN)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CNN)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CUN)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].ESNErr <> 0 then write (f,' class="error"');
      writeln (f,'>'+f2s (Recs [i].ESN) +'</td>');
      write (f,'     <td class="error">');
      if Recs [i].QueryLastPerErr then write (f,'') else write (f,'&nbsp;');
      writeln (f,'</td>');
      write (f,'     <td class="error">');
      if Recs [i].ESSErr = 1 then write (f,'')
      else if Recs [i].ESSErr = 2 then write (f,'')
      else write (f,'&nbsp;');
      writeln (f,'</td>');
      write (f,'     <td class="error">');
      if Recs [i].ESNErr = 1 then write (f,'')
      else if Recs [i].ESNErr = 2 then write (f,'')
      else write (f,'&nbsp;');
      writeln (f,'</td>');
      writeln (f,'    </tr>');
     end;
 //  
 writeln (f,'   </table>');
 //  
 writeln (f,'   <h3> :</h3>');
 writeln (f,'   <ul>');
 writeln (f,'    <li><b></b> -   (  , .     );</li>');
 writeln (f,'    <li><b></b> - ;</li>');
 writeln (f,'    <li><b></b> -        .</li>');
 writeln (f,'   </ul>');
 //  
 writeln (f,' </body>');
 writeln (f,'</html>');
 CloseFile (f);
end;

//     XML Spreadsheet
procedure TPTKProt.MakeExcel (FileName: AnsiString);
var
 f                   : TextFile;
 i,i1,i2             : integer;
 PackIndex           : string;
 s                   : string;
begin
  //  
 AssignFile (f,FileName);
 rewrite (f);
 //  
 writeln (f,'<?xml version="1.0" encoding="windows-1251"?>');
 writeln (f,'<?mso-application progid="Excel.Sheet"?>');
 writeln (f,'<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"');
 writeln (f,' xmlns:o="urn:schemas-microsoft-com:office:office"');
 writeln (f,' xmlns:x="urn:schemas-microsoft-com:office:excel"');
 writeln (f,' xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"');
 writeln (f,' xmlns:html="http://www.w3.org/TR/REC-html40">');
 writeln (f,' <DocumentProperties xmlns="urn:schemas-microsoft-com:office:office">');
 writeln (f,'  <Version>12.00</Version>');
 writeln (f,' </DocumentProperties>');
 writeln (f,' <ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel">');
 writeln (f,'  <WindowHeight>4905</WindowHeight>');
 writeln (f,'  <WindowWidth>18195</WindowWidth>');
 writeln (f,'  <WindowTopX>360</WindowTopX>');
 writeln (f,'  <WindowTopY>75</WindowTopY>');
 writeln (f,'  <RefModeR1C1/>');
 writeln (f,'  <ProtectStructure>False</ProtectStructure>');
 writeln (f,'  <ProtectWindows>False</ProtectWindows>');
 writeln (f,' </ExcelWorkbook>');
 writeln (f,' <Styles>');
 writeln (f,'  <Style ss:ID="Default" ss:Name="Normal">');
 writeln (f,'   <Alignment ss:Vertical="Bottom"/>');
 writeln (f,'   <Borders/>');
 writeln (f,'   <Font ss:FontName="Calibri" x:CharSet="204" x:Family="Swiss" ss:Size="11"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'   <NumberFormat/>');
 writeln (f,'   <Protection/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="m40037684">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000" ss:Bold="1"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s64">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000" ss:Bold="1"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s65">');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s66">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Bottom"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s67">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s68">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <NumberFormat ss:Format="#,##0.00&quot;.&quot;"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s69">');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s70">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Bottom"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s71">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'   <NumberFormat ss:Format="#,##0.00&quot;.&quot;"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s72">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000" ss:Bold="1"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s73">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000" ss:Bold="1"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s76">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Bottom"/>');
 writeln (f,'   <Borders/>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s77">');
 writeln (f,'   <Borders/>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s78">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <NumberFormat ss:Format="Standard"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s79">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#FF0000"/>');
 writeln (f,'   <NumberFormat ss:Format="Standard"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s80">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Arial" x:CharSet="204" x:Family="Swiss" ss:Size="8"');
 writeln (f,'    ss:Color="#000000"/>');
 writeln (f,'   <Interior/>');
 writeln (f,'   <NumberFormat ss:Format="Standard"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s84">');
 writeln (f,'   <Font ss:FontName="Calibri" x:CharSet="204" x:Family="Swiss" ss:Size="11"');
 writeln (f,'    ss:Color="#000000" ss:Bold="1"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s85">');
 writeln (f,'   <Font ss:FontName="Calibri" x:CharSet="204" x:Family="Swiss" ss:Size="11"');
 writeln (f,'    ss:Color="#FF0000" ss:Bold="1"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s86">');
 writeln (f,'   <Font ss:FontName="Calibri" x:CharSet="204" x:Family="Swiss" ss:Size="11"');
 writeln (f,'    ss:Bold="1"/>');
 writeln (f,'  </Style>');
 writeln (f,'  <Style ss:ID="s87">');
 writeln (f,'   <Alignment ss:Horizontal="Center" ss:Vertical="Center"/>');
 writeln (f,'   <Borders>');
 writeln (f,'    <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'    <Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1"/>');
 writeln (f,'   </Borders>');
 writeln (f,'   <Font ss:FontName="Calibri" x:CharSet="204" x:Family="Swiss" ss:Size="11"');
 writeln (f,'    ss:Color="#FF0000"/>');
 writeln (f,'  </Style>');
 writeln (f,' </Styles>');
 //  
 writeln (f,' <Worksheet ss:Name="">');
 writeln (f,'  <Table ss:ExpandedColumnCount="1" ss:ExpandedRowCount="19" x:FullColumns="1"');
 writeln (f,'   x:FullRows="1" ss:DefaultRowHeight="15">');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s84"><Data ss:Type="String">         </Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s84"><Data ss:Type="String"> VL: '+ProgVersion+'</Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 if DebugBuild
  then begin
        writeln (f,'    <Cell ss:StyleID="s85"><Data ss:Type="String">   </Data></Cell>');
       end;
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s85"/>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s86"><Data ss:Type="String">  </Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s85"/>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell><Data ss:Type="String"> : '+BriefName+'</Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell><Data ss:Type="String">   : '+RegNumb+'</Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell><Data ss:Type="String">    : '+DateToStr (Date)+' '+TimeToStr (Time)+'</Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s85"/>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s84"><Data ss:Type="String">   </Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s85"/>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 //      
 writeln (f,'    <Cell><Data ss:Type="String">   : '+PFRFileName+' ,  '+PFRFileType+'    '+PFRFileDate+'</Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell><Data ss:Type="String">      : '+PFRFilePer+'</Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s85"/>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row ss:StyleID="s84">');
 writeln (f,'    <Cell><Data ss:Type="String">     :</Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:StyleID="s85"/>');
 writeln (f,'   </Row>');
 for i := 0 to Length (Files) - 1
  do with Files [i]
   do begin
       writeln (f,'   <Row>');
       write (f,'    <Cell><Data ss:Type="String">'+FileName+' - '+FormType+'  '+ strPeriod (OtYear,OtPer)+',  '+CatCode);
       if FormType = '-6-4' then write (f,', '+DogType+' ');
       writeln (f,'</Data></Cell>');
       writeln (f,'   </Row>');
      end;
 writeln (f,'  </Table>');
 writeln (f,'  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">');
 writeln (f,'   <PageSetup>');
 writeln (f,'    <Header x:Margin="0.3"/>');
 writeln (f,'    <Footer x:Margin="0.3"/>');
 writeln (f,'    <PageMargins x:Bottom="0.75" x:Left="0.7" x:Right="0.7" x:Top="0.75"/>');
 writeln (f,'   </PageSetup>');
 writeln (f,'   <Print>');
 writeln (f,'    <ValidPrinterInfo/>');
 writeln (f,'    <PaperSizeIndex>9</PaperSizeIndex>');
 writeln (f,'    <HorizontalResolution>600</HorizontalResolution>');
 writeln (f,'    <VerticalResolution>0</VerticalResolution>');
 writeln (f,'   </Print>');
 writeln (f,'   <Selected/>');
 writeln (f,'   <ProtectObjects>False</ProtectObjects>');
 writeln (f,'   <ProtectScenarios>False</ProtectScenarios>');
 writeln (f,'  </WorksheetOptions>');
 writeln (f,' </Worksheet>');
 writeln (f,' <Worksheet ss:Name="">');
 // 
 writeln (f,'  <Table ss:ExpandedColumnCount="17" ss:ExpandedRowCount="10" x:FullColumns="1"');
 writeln (f,'   x:FullRows="1" ss:DefaultRowHeight="15">');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="31.5"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="69.75"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="179.25"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="40.5"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="63.75"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="51.75"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="63.75"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="61.5"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="60.75" ss:Span="1"/>');
 writeln (f,'   <Column ss:Index="11" ss:AutoFitWidth="0" ss:Width="57.75"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="53.25"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="57.75"/>');
 writeln (f,'   <Column ss:AutoFitWidth="0" ss:Width="54.75"/>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:MergeDown="1" ss:StyleID="s64"><Data ss:Type="String"> /</Data></Cell>');
 writeln (f,'    <Cell ss:MergeDown="1" ss:StyleID="s64"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'    <Cell ss:MergeDown="1" ss:StyleID="s64"><Data ss:Type="String">, , </Data></Cell>');
 writeln (f,'    <Cell ss:MergeDown="1" ss:StyleID="s64"><Data ss:Type="String"> /  </Data></Cell>');
 writeln (f,'    <Cell ss:MergeDown="1" ss:StyleID="m40037684"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'    <Cell ss:MergeDown="1" ss:StyleID="s64"><Data ss:Type="String"> /  </Data></Cell>');
 writeln (f,'    <Cell ss:MergeAcross="3" ss:StyleID="s64"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'    <Cell ss:MergeAcross="3" ss:StyleID="s64"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'    <Cell ss:MergeAcross="2" ss:StyleID="s64"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row ss:Height="22.5">');
 writeln (f,'    <Cell ss:Index="7" ss:StyleID="s64"><Data ss:Type="String">  </Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String">  </Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s73"><Data ss:Type="String">. </Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s64"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s72"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'   </Row>');
 //    
 for i := 0 to Length (Recs) - 1
  do begin
      writeln (f,'   <Row>');
      writeln (f,'    <Cell ss:StyleID="s65"><Data ss:Type="Number">'+IntToStr (i+1)+'</Data></Cell>');
      writeln (f,'    <Cell ss:StyleID="s66"><Data ss:Type="String">'+NumberToSNILS (Recs [i].SNILS)+'</Data></Cell>');
      writeln (f,'    <Cell ss:StyleID="s65"><Data ss:Type="String">'+Recs [i].FIO+'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="s66">');
      if Recs [i].SSExists then write (f,'<Data ss:Type="Number">',Recs [i].QueryNumber,'</Data>') else write (f,'<Data ss:Type="String">-</Data>');
      writeln (f,'</Cell>');
      // s79 - 
      write (f,'    <Cell ss:StyleID="');
      if Recs [i].QueryLastPerErr then write (f,'s79') else write (f,'s66');
      write (f,'"><Data ss:Type="String">');
      if Recs [i].SSExists then write (f,Recs [i].QueryLastPer) else write (f,'-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="s67"><Data ss:Type="String">');
      if Recs [i].CExists then write (f,Recs [i].FileNumber) else write (f,'-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="');
      if Recs [i].SSSErr then write (f,'s79') else write (f,'s78');
      write (f,'">');
      if Recs [i].SSExists then write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].SSS)) else write (f,'<Data ss:Type="String">-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="s78">');
      if Recs [i].CExists then write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].CNS)) else write (f,'<Data ss:Type="String">-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="s78">');
      if Recs [i].CExists then write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].CUS)) else write (f,'<Data ss:Type="String">-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="');
      if Recs [i].ESSErr <> 0 then write (f,'s79') else write (f,'s78');
      write (f,'">');
      write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].ESS));
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="');
      if Recs [i].SSNErr then write (f,'s79') else write (f,'s78');
      write (f,'">');
      if Recs [i].SSExists then write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].SSN)) else write (f,'<Data ss:Type="String">-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="s78">');
      if Recs [i].CExists then write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].CNN)) else write (f,'<Data ss:Type="String">-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="s78">');
      if Recs [i].CExists then write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].CUN)) else write (f,'<Data ss:Type="String">-');
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="');
      if Recs [i].ESNErr <> 0 then write (f,'s79') else write (f,'s78');
      write (f,'">');
      write (f,'<Data ss:Type="Number">'+f2s2 (Recs [i].ESN));
      writeln (f,'</Data></Cell>');
      write (f,'    <Cell ss:StyleID="s87">');
      if Recs [i].QueryLastPerErr then write (f,'<Data ss:Type="String"></Data>');
      writeln (f,'</Cell>');
      writeln (f,'    <Cell ss:StyleID="s87"><Data ss:Type="String">');
      if Recs [i].ESSErr = 1 then write (f,'')
      else if Recs [i].ESSErr = 2 then write (f,'');
      writeln (f,'</Data></Cell>');
      writeln (f,'    <Cell ss:StyleID="s87"><Data ss:Type="String">');
      if Recs [i].ESNErr = 1 then write (f,'')
      else if Recs [i].ESNErr = 2 then write (f,'');
      writeln (f,'</Data></Cell>');
      writeln (f,'   </Row>');
     end;
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:Index="2" ss:StyleID="s76"><Data ss:Type="String">:</Data></Cell>');
 writeln (f,'    <Cell ss:StyleID="s77"><Data ss:Type="String"> -  </Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:Index="3" ss:StyleID="s77"><Data ss:Type="String"> - </Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'   <Row>');
 writeln (f,'    <Cell ss:Index="3" ss:StyleID="s77"><Data ss:Type="String"> -        </Data></Cell>');
 writeln (f,'   </Row>');
 writeln (f,'  </Table>');
 //       ( )
 writeln (f,'  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">');
 writeln (f,'   <PageSetup>');
 writeln (f,'    <Header x:Margin="0.3"/>');
 writeln (f,'    <Footer x:Margin="0.3"/>');
 writeln (f,'    <PageMargins x:Bottom="0.75" x:Left="0.7" x:Right="0.7" x:Top="0.75"/>');
 writeln (f,'   </PageSetup>');
 writeln (f,'   <Print>');
 writeln (f,'    <ValidPrinterInfo/>');
 writeln (f,'    <PaperSizeIndex>9</PaperSizeIndex>');
 writeln (f,'    <HorizontalResolution>600</HorizontalResolution>');
 writeln (f,'    <VerticalResolution>0</VerticalResolution>');
 writeln (f,'   </Print>');
 writeln (f,'   <Selected/>');
 writeln (f,'   <ProtectObjects>False</ProtectObjects>');
 writeln (f,'   <ProtectScenarios>False</ProtectScenarios>');
 writeln (f,'   <FreezePanes/>');
 writeln (f,'   <FrozenNoSplit/>');
 writeln (f,'   <SplitHorizontal>2</SplitHorizontal>');
 writeln (f,'   <TopRowBottomPane>2</TopRowBottomPane>');
 writeln (f,'   <ActivePane>2</ActivePane>');
 writeln (f,'   <Panes>');
 writeln (f,'    <Pane>');
 writeln (f,'     <Number>3</Number>');
 writeln (f,'    </Pane>');
 writeln (f,'    <Pane>');
 writeln (f,'     <Number>1</Number>');
 writeln (f,'    </Pane>');
 writeln (f,'    <Pane>');
 writeln (f,'     <Number>2</Number>');
 writeln (f,'     <ActiveRow>2</ActiveRow>');
 writeln (f,'     <ActiveCol>0</ActiveCol>');
 writeln (f,'    </Pane>');
 writeln (f,'    <Pane>');
 writeln (f,'     <Number>0</Number>');
 writeln (f,'    </Pane>');
 writeln (f,'   </Panes>');
 writeln (f,'  </WorksheetOptions>');
 writeln (f,' </Worksheet>');
 writeln (f,'</Workbook>');
 //  
 CloseFile (f);
end;

end.
