unit office;

//  VL:
// Copyright (C) 2013  . .

//        Excel   Microsoft Office  OpenOffice
//       ;   Microsoft Office

interface

uses Variants;

type

 TXLSData = object
            private
             Prog      : integer; //   (0 - , 1 - MS Office, 2 - OpenOffice)
             Excel     : Variant;
             OOCalc    : Variant;
             OODesktop : Variant;
             Workbook  : Variant;
             WorkSheet : Variant;
             ooCoreReflection : Variant;
             ooArgs : array [0..4] of Variant;
             function OOOpen (FileName : ANSIString) : Boolean;
             procedure OOSetActiveSheet (Index : integer);
             function OOGetCellValue (Cell : ANSIString) : Variant;
             procedure OOClose;
             procedure OODone;
             function ExcelOpen (FileName : ANSIString) : Boolean;
             procedure ExcelSetActiveSheet (Index : integer);
             function ExcelGetCellValue (Cell : ANSIString) : Variant;
             procedure ExcelClose;
             procedure ExcelDone;
            public
             //      MS Office  OpenOffice
             function Init : Boolean;
             //  Excel-
             function Open (FileName : ANSIString): Boolean;
             //    (  1)
             procedure SetActiveSheet (Index : integer);
             //    (   R1C1,   - )
             function GetCellValue (Cell : ANSIString) : Variant;
             //  
             procedure Close;
             //   
             procedure Done;
            end;

implementation

uses ComObj;

//    X  Y     R1C1
function getCoords (const s : string; var x,y : integer) : Boolean;
var
 Code,i : integer;
begin
 if s [1] = 'R'
  then begin
        i := Pos ('C',s);
        if i > 0
         then begin
               Val (Copy (s,2,i-2),y,Code);
               if Code <> 0 then getCoords := False
               else begin
                     Val (Copy (s,i+1,Length (s)-i),x,Code);
                     getCoords := (Code = 0);
                    end;
              end
         else getCoords := False;
       end
  else getCoords := False;
end;

//   TXLSData

// OpenOffice

//  
function TXLSData.OOOpen (FileName : ANSIString) : Boolean;
var
 FileURL  : String;
 ooParams : Variant;
 i        : integer;
begin
 //     URL
 FileURL := 'file:///';
 for I := 1 to Length (FileName)
  do if FileName [i] = '\' then FileURL := FileURL + '/'
   else FileURL := FileURL + FileName [i];
 //   
 ooParams := VarArrayCreate ([0, 2], varVariant);
 ooParams [0] := ooCalc.Bridge_GetStruct ('com.sun.star.beans.PropertyValue');
 ooParams [1] := ooCalc.Bridge_GetStruct ('com.sun.star.beans.PropertyValue');
 ooArgs [0].Name := 'Hidden';
 ooArgs [0].Value := True;
 ooArgs [1].Name := 'ReadOnly';
 ooArgs [1].Value := True;
 ooParams [0] := ooArgs [0];
 ooParams [1] := ooArgs [1];
 try
  Workbook := OODesktop.LoadComponentFromURL (FileURL,'_blank',0,ooParams);
  Result := True;
 except
  Result := False;
 end;
end;

//   
procedure TXLSData.OOSetActiveSheet (Index : integer);
begin
 WorkSheet := WorkBook.getSheets.getByIndex (Index - 1);
end;

//   
function TXLSData.OOGetCellValue (Cell: AnsiString) : Variant;
var
 x,y : integer;
begin
 if GetCoords (Cell,x,y)
  then Result := WorkSheet.getCellByPosition(x-1,y-1).getString;
end;

//  
procedure TXLSData.OOClose;
begin
 WorkBook.Close (True);
 WorkSheet := unAssigned;
 WorkBook := unAssigned;
end;

//  
procedure TXLSData.OODone;
begin
 ooCoreReflection := unAssigned;
 OODesktop := unAssigned;
 OOCalc := unAssigned;
end;

// Excel

//  
function TXLSData.ExcelOpen (FileName : ANSIString) : Boolean;
begin
 try
  Excel.Workbooks.Open (FileName);
  WorkBook := Excel.WorkBooks.item [Excel.WorkBooks.count];
  WorkBook.Activate;
  Result := True;
 except
  Result := False;
 end;
end;

//   
procedure TXLSData.ExcelSetActiveSheet (Index : integer);
begin
 WorkSheet := WorkBook.Sheets [Index];
 WorkSheet.Activate;
end;

//   
function TXLSData.ExcelGetCellValue (Cell: AnsiString) : Variant;
var
 x,y : integer;
 C : Variant;
begin
 if GetCoords (Cell,x,y)
  then begin
        c := WorkSheet.Cells [y,x];
        Result := c.Text;
       end;
end;

//  
procedure TXLSData.ExcelClose;
begin
 WorkBook.Close;
end;

procedure TXLSData.ExcelDone;
begin
 Excel := unAssigned;
end;

//   TXLSData

function TXLSData.Init : Boolean;
var
 i : integer;
begin
 //  (    MS Office  OpenOffice)
 //       MS Office
 try
  //     Excel
  Excel := CreateOleObject ('Excel.Application');
  Excel.Visible := False;
  Excel.DisplayAlerts := False;
  Prog := 1;
  Result := True;
 except
  //  Excel ,  OpenOffice
  try
   OOCalc := CreateOleObject ('com.sun.star.ServiceManager');
   ooCoreReflection:= OOCalc.createInstance ('com.sun.star.reflection.CoreReflection');
   //  5      OpenOffice
   for i := 0 to 4 do OOCoreReflection.forName ('com.sun.star.beans.PropertyValue').createObject (ooArgs [i]);
   //  desktop 
   OODesktop := OOCalc.CreateInstance ('com.sun.star.frame.Desktop');
   Prog := 2;
   Result := True;
  except
   Result := False;
  end;
 end;

end;

//     
function TXLSData.Open (FileName : ANSIString): Boolean;
begin
 //  
 if Prog = 1 then Result := ExcelOpen (FileName)
 else if Prog = 2 then Result := OOOpen (FileName)
 else Result := False;
end;

procedure TXLSData.SetActiveSheet (Index: Integer);
begin
 //     
 if Prog = 1 then ExcelSetActiveSheet (Index)
 else if Prog = 2 then OOSetActiveSheet (Index);
end;

function TXLSData.GetCellValue (Cell: AnsiString) : Variant;
begin
 //   
 if Prog = 1 then Result := ExcelGetCellValue (Cell)
 else if Prog = 2 then Result := OOGetCellValue (Cell)
 else Result := False;
end;

procedure TXLSData.Close;
begin
 //  
 if Prog = 1 then ExcelClose
 else if Prog = 2 then OOClose;
end;

procedure TXLSData.Done;
begin
 if Prog = 1 then ExcelDone
 else if Prog = 2 then OODone;     
end;

end.
