unit szv6;

//        -6
// Copyright (C) 2011  . .
//  2.0  22.03.2013 .

interface

// unit Controls   uses    Delphi 7
uses Controls;

type

 //    -6
 TSZV6Lgot = class
              TUOsn      : string [4];   // .  - 
              TUCoeff    : Currency;     // .  - 
              OUTOsn     : string [6];   //    - 
              OUTKPS     : string [20];  //    -   
              ISOsn      : string [7];   //    - 
              ISVHours   : integer;      //    -   
              ISVMinutes : integer;      //    -   
              ISVMonths  : integer;      //    -   
              ISVDays    : integer;      //    -   
              VLOsn      : string [8];   //   - 
              VLHours    : integer;      //   -   
              VLMinutes  : integer;      //   -   
              VLMonths   : integer;      //   -   
              VLDays     : integer;      //   -   
              VLDS       : Currency;     //   -  
              Dekret     : string [10];  // --.
              constructor Create;
             end;


 //    -6
 TSZV6Stage = class
               StartDate : TDate;                //   
               EndDate   : TDate;                //   
               Lgots     : array of TSZV6Lgot;   //  
               constructor Create;
               destructor Destroy;
              end;

 //  .  -6
 TSZV6 = class
          NumInPack  : integer;             //   
          StrNumb    : string [14];         //  
          SurName    : string [40];         // 
          Name       : string [40];         // 
          FatherName : string [40];         // 
          AddrType   : string [20];         //   
          AddrCode   : string [3];          //   (  )
          AddrName   : string [100];        //   (  )
          AddrTxt    : string [200];        //   
          AddrIndex  : string [6];          //  
          AddrRegion : string [50];         // 
          AddrRayon  : string [50];         // 
          AddrGorod  : string [50];         // 
          AddrTown   : string [50];         //  
          AddrStreet : string [50];         // 
          AddrDom    : string [50];         // 
          AddrCorpus : string [50];         // 
          AddrQuart  : string [50];         // 
          NS         : Currency;            //   
          NN         : Currency;            //   
          US         : Currency;            //   
          UN         : Currency;            //   
          Stages     : array of TSZV6Stage; //  
          ZapDate    : TDate;               //  
          SostDateNa : TDate;               //   
          constructor Create;
          destructor Destroy;
         end;

 //    .  -6
 TSZV6File = class
              FileName     : string;         //  
              PackNumb     : LongInt;        //  
              VidFormy     : string [7];     //  
              SvedType     : string [15];    //  
              OtYear       : integer;        //  
              OtPer        : integer;        //  
              CorrYear     : integer;        //   
              CorrPer      : integer;        //   
              DogType      : string [19];    //   (  -6-4)
              StrName      : string [200];   //  
              StrBriefName : string [200];   //   
              StrNumb      : string [14];    // .  
              CatCode      : string [4];     //   
              SostDate     : TDate;          //   
              SZV6Arr      : array of TSZV6; //   . 
              constructor Create;
              destructor Destroy;
              procedure Clear;               //  
              function Read : Boolean;       //  
             end;

implementation

uses SysUtils,xmlwork;

constructor TSZV6Lgot.Create;
begin
 TUOsn := '';
 TUCoeff := 0;
 OUTOsn := '';
 OUTKPS := '';
 ISOsn := '';
 ISVHours := 0;
 ISVMinutes := 0;
 ISVMonths := 0;
 ISVDays := 0;
 VLOsn := '';
 VLHours := 0;
 VLMinutes := 0;
 VLMonths := 0;
 VLDays := 0;
 VLDS := 0;
 Dekret := '';
end;

constructor TSZV6Stage.Create;
begin
 StartDate := 0;
 EndDate := 0;
 SetLength (Lgots,0);
end;

destructor TSZV6Stage.Destroy;
var
 i : integer;
begin
 if Length (Lgots) > 0 then for I := Low (Lgots) to High (Lgots) do Lgots [i].Destroy;
 SetLength (Lgots,0);
 inherited Destroy;
end;

constructor TSZV6.Create;
begin
 NumInPack := 0;
 StrNumb := '';
 SurName := '';
 Name := '';
 FatherName := '';
 AddrType := '';
 AddrCode := '';
 AddrName := '';
 AddrTxt := '';
 AddrIndex := '';
 AddrRegion := '';
 AddrRayon := '';
 AddrGorod := '';
 AddrTown := '';
 AddrStreet := '';
 AddrDom := '';
 AddrCorpus := '';
 AddrQuart := '';
 NS := 0;
 NN := 0;
 US := 0;
 UN := 0;
 SetLength (Stages,0);
 SostDateNa := 0;
 ZapDate := 0;
end;

destructor TSZV6.Destroy;
var
 i : integer;
begin
 if Length (Stages) > 0 then for I := Low (Stages) to High (Stages) do Stages [i].Destroy;
 SetLength (Stages,0);
 inherited Destroy;
end;

constructor TSZV6File.Create;
begin
 FileName := '';
 PackNumb := 0;
 SvedType := '';
 // CorrVid := '';
 OtYear := 0;
 OtPer := 0;
 CorrYear := 0;
 CorrPer := 0;
 CatCode := '';
 DogType := '';
 StrName := '';
 StrNumb := '';
 VidFormy := '';
 SetLength (SZV6Arr,0);
end;

destructor TSZV6File.Destroy;
var
 i : integer;
begin
 if Length (SZV6Arr) > 0 then for I := Low (SZV6Arr) to High (SZV6Arr) do SZV6Arr [i].Destroy;
 SetLength (SZV6Arr,0);
 inherited Destroy;
end;

procedure TSZV6File.Clear;
var
 i : integer;
begin
 if Length (SZV6Arr) > 0 then for I := Low (SZV6Arr) to High (SZV6Arr) do SZV6Arr [i].Destroy;
 SetLength (SZV6Arr,0);
 // Filename := '';
 PackNumb := 0;
 SvedType := '';
 // CorrVid := '';
 OtYear := 0;
 OtPer := 0;
 CorrYear := 0;
 CorrPer := 0;
 StrName := '';
 StrNumb := '';
 CatCode := '';
 SostDate := 0;
end;

function TSZV6File.Read;
var
 XML             : TXMLFile;
 i,j,k,l,m,n,o,p : integer;
 Code            : integer;
 SvedCounter     : integer;
 StageCounter    : integer;
 LgotCounter     : integer;
 GName,Socr      : string;
 c               : real;
 FS              : TFormatSettings;
begin
 GetLocaleFormatSettings (1049,FS);
 with FS
  do begin
      DateSeparator := '.';
      ShortDateFormat := 'dd/mm/yyyy';
     end;
 Clear;
 SvedCounter := 0;
 XML := TXMLFile.Create;
 if XML.ReadFromFile (FileName) = False then Read := False
 else if not XML.Parse then Read := False
 else begin
       if XML.Tag.Name <> '' then Read := False
       else for i := Low (XML.Tag.Child) to High (XML.Tag.Child)
        do if XML.Tag.Child [i].Name = ''
         then for j := Low (XML.Tag.Child [i].Child) to High (XML.Tag.Child [i].Child)
          // -6-3
          do if XML.Tag.Child [i].Child [j].Name = '____'
           then begin
                 for k := Low (XML.Tag.Child [i].Child [j].Child) to High (XML.Tag.Child [i].Child [j].Child)
                  do if XML.Tag.Child [i].Child [j].Child [k].Name=''
                   then begin
                         for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                          do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                           then StrName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                           else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                            then StrNumb := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                            else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                             then StrBriefName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value;
                        end
                   else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                    then begin
                          for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                           do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                            then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,PackNumb,Code);
                         end
                    else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                     then SvedType := XML.Tag.Child [i].Child [j].Child [k].Value
                     else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                     then CatCode := XML.Tag.Child [i].Child [j].Child [k].Value
                      else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                      then begin
                            for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                             do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                              then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,OtYear,Code)
                              else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                              then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,OtPer,Code);
                           end
                      else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                       then begin
                             for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                              do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                               then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,CorrYear,Code)
                               else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                               then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,CorrPer,Code);
                            end
                       else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                        then SostDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Value),FS);
                end
           // -6-5
           else if XML.Tag.Child [i].Child [j].Name = '________'
           then begin
                 for k := Low (XML.Tag.Child [i].Child [j].Child) to High (XML.Tag.Child [i].Child [j].Child)
                  do if XML.Tag.Child [i].Child [j].Child [k].Name=''
                   then begin
                         for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                          do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                           then StrName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                           else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                            then StrNumb := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                            else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                             then StrBriefName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value;
                        end
                   else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                    then begin
                          for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                           do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                            then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,PackNumb,Code);
                         end
                    else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                     then SvedType := XML.Tag.Child [i].Child [j].Child [k].Value
                     else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                     then CatCode := XML.Tag.Child [i].Child [j].Child [k].Value
                      else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                      then begin
                            for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                             do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                              then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,OtYear,Code)
                              else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                              then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,OtPer,Code);
                           end
                      else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                       then begin
                             for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                              do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                               then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,CorrYear,Code)
                               else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                               then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,CorrPer,Code);
                            end
                      else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                        then DogType := XML.Tag.Child [i].Child [j].Child [k].Value
                       else if XML.Tag.Child [i].Child [j].Child [k].Name=''
                        then SostDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Value),FS);

                end
           // -6-1  -6-2
           else if XML.Tag.Child [i].Child [j].Name = '_______'
            then begin
                  Read := True;
                  Inc (SvedCounter);
                  SetLength (SZV6Arr,SvedCounter);
                  SZV6Arr [SvedCounter-1] := TSZV6.Create;
                  StageCounter := 0;
                  for k := Low (XML.Tag.Child [i].Child [j].Child) to High (XML.Tag.Child [i].Child [j].Child)
                   do if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                   then  Val (XML.Tag.Child [i].Child [j].Child [k].Value,SZV6Arr [SvedCounter-1].NumInPack,p)
                   else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                    then SZV6Arr [SvedCounter-1].StrNumb:= XML.Tag.Child [i].Child [j].Child [k].Value
                    else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                     then begin
                           for l := 0 to Length (XML.Tag.Child [i].Child [j].Child [k].Child)-1
                            do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                             then SZV6Arr [SvedCounter-1].SurName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                             else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                              then SZV6Arr [SvedCounter-1].Name := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                              else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                               then SZV6Arr [SvedCounter-1].FatherName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value;
                          end
                     else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                      then begin
                            for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                             do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name='' then SZV6Arr [SvedCounter-1].AddrType := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                             else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name='' then SZV6Arr [SvedCounter-1].AddrIndex := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                             else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                              then begin
                                    for m := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child)
                                     do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                      then begin
                                            GName := '';
                                            Socr := '';
                                            for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                             do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                             else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                            SZV6Arr [SvedCounter-1].AddrRegion := GName;
                                            if Socr <> '' then SZV6Arr [SvedCounter-1].AddrRegion := SZV6Arr [SvedCounter-1].AddrRegion + ' ' + Socr;
                                           end
                                      else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                       then begin
                                             GName := '';
                                             Socr := '';
                                             for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                              do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                              else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                             SZV6Arr [SvedCounter-1].AddrRayon := GName;
                                             if Socr <> '' then SZV6Arr [SvedCounter-1].AddrRayon := SZV6Arr [SvedCounter-1].AddrRayon + ' ' + Socr;
                                            end
                                       else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                        then begin
                                              GName := '';
                                              Socr := '';
                                              for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                               do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                               else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                              SZV6Arr [SvedCounter-1].AddrGorod := GName;
                                              if Socr <> '' then SZV6Arr [SvedCounter-1].AddrGorod := SZV6Arr [SvedCounter-1].AddrGorod + ' ' + Socr;
                                             end
                                        else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                         then begin
                                               GName := '';
                                               Socr := '';
                                               for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                                do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                                else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                               SZV6Arr [SvedCounter-1].AddrTown := GName;
                                               if Socr <> '' then SZV6Arr [SvedCounter-1].AddrTown := SZV6Arr [SvedCounter-1].AddrTown + ' ' + Socr;
                                              end
                                         else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                          then begin
                                                GName := '';
                                                Socr := '';
                                                for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                                 do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                                 else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                                SZV6Arr [SvedCounter-1].AddrStreet := GName;
                                                if Socr <> '' then SZV6Arr [SvedCounter-1].AddrStreet := SZV6Arr [SvedCounter-1].AddrStreet + ' ' + Socr;
                                               end
                                          else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                           then begin
                                                 GName := '';
                                                 Socr := '';
                                                 for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                                  do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                                  else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                                 SZV6Arr [SvedCounter-1].AddrDom := GName;
                                                 if Socr <> '' then SZV6Arr [SvedCounter-1].AddrDom := Socr+ ' ' + SZV6Arr [SvedCounter-1].AddrDom;
                                                end
                                           else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                            then begin
                                                  GName := '';
                                                  Socr := '';
                                                  for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                                   do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                                   else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                                  SZV6Arr [SvedCounter-1].AddrCorpus := GName;
                                                  if Socr <> '' then SZV6Arr [SvedCounter-1].AddrCorpus := Socr+ ' ' + SZV6Arr [SvedCounter-1].AddrCorpus;
                                                 end
                                            else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name=''
                                             then begin
                                                   GName := '';
                                                   Socr := '';
                                                   for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                                    do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                                    else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = '' then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value;
                                                   SZV6Arr [SvedCounter-1].AddrQuart := GName;
                                                   if Socr <> '' then SZV6Arr [SvedCounter-1].AddrQuart := Socr+ ' ' + SZV6Arr [SvedCounter-1].AddrQuart;
                                                  end;
                                   end
                              else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                               then begin
                                     for m := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child)
                                      do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name='' then SZV6Arr [SvedCounter-1].AddrCode := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Value
                                      else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name='' then SZV6Arr [SvedCounter-1].AddrName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Value
                                      else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name='' then SZV6Arr [SvedCounter-1].AddrTxt := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Value;
                                    end;
                           end
                      else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                       then begin
                             for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                              do if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                              else if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value;
                             if (GName <> '') and (Socr <> '')
                              then begin
                                    Inc (StageCounter);
                                    SetLength (SZV6Arr [SvedCounter-1].Stages,StageCounter);
                                    LgotCounter := 0;
                                    SZV6Arr [SvedCounter-1].Stages [StageCounter-1] := TSZV6Stage.Create;
                                    for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                                     do if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].StartDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value),FS)
                                     else if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].EndDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value),FS)
                                     else if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '')
                                      then begin
                                            Inc (LgotCounter);
                                            SetLength (SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots,LgotCounter);
                                            SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1] := TSZV6Lgot.Create;
                                            for m := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child)
                                             do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name = ''
                                              then for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                               do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                then begin
                                                      for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                       do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = '' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].TUOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                       else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = ''
                                                        then begin
                                                              Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value,c,Code);
                                                              SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].TUCoeff := c;
                                                             end;
                                                     end
                                                else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                 then begin
                                                       for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                        do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name='' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].OUTOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                        else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = '' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].OUTKPS := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value;
                                                      end
                                                 else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                  then begin
                                                        for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                         do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name='' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                         else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                          then begin
                                                                for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                 do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVMonths,Code)
                                                                 else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVDays,Code);
                                                               end
                                                          else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                           then begin
                                                                 for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                  do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVHours,Code)
                                                                  else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVMinutes,Code);
                                                                end;
                                                       end
                                                  else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                   then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].Dekret := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                                   else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                    then begin
                                                          for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                           do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name='' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                           else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                            then begin
                                                                  for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                   do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLMonths,Code)
                                                                   else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLDays,Code);
                                                                 end
                                                            else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                             then begin
                                                                   for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                    do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLHours,Code)
                                                                    else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLMinutes,Code);
                                                                  end
                                                             else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = ''
                                                              then begin
                                                                    Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value,c,Code);
                                                                    SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLDS := c;
                                                                   end;
                                                         end;
                                           end;
                                   end;
                             //  -  
                            end
                       //     
                       else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                        then begin
                              for l := 0 to Length (XML.Tag.Child [i].Child [j].Child [k].Child) - 1 do
                               if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                then begin
                                      Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                      SZV6Arr [SvedCounter-1].NS := c;
                                     end
                                else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                then begin
                                      Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                      SZV6Arr [SvedCounter-1].US := c;
                                     end;
                             end
                        else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                         then begin
                               for l := 0 to Length (XML.Tag.Child [i].Child [j].Child [k].Child) - 1 do
                                if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                 then begin
                                       Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                       SZV6Arr [SvedCounter-1].NN := c;
                                      end
                                 else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                 then begin
                                       Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                       SZV6Arr [SvedCounter-1].UN := c;
                                      end;
                              end
                         else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                          then VidFormy := XML.Tag.Child [i].Child [j].Child [k].Value
                          else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                           then SZV6Arr [SvedCounter-1].ZapDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Value),FS)
                           else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                            then SZV6Arr [SvedCounter-1].SostDateNa := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Value),FS);
                 end
           // -6-4
           else if XML.Tag.Child [i].Child [j].Name = '__________'
            then begin
                  VidFormy := '-6-4';
                  Read := True;
                  Inc (SvedCounter);
                  SetLength (SZV6Arr,SvedCounter);
                  SZV6Arr [SvedCounter-1] := TSZV6.Create;
                  StageCounter := 0;
                  for k := Low (XML.Tag.Child [i].Child [j].Child) to High (XML.Tag.Child [i].Child [j].Child)
                   do if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                   then  Val (XML.Tag.Child [i].Child [j].Child [k].Value,SZV6Arr [SvedCounter-1].NumInPack,p)
                   else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                    then SZV6Arr [SvedCounter-1].StrNumb:= XML.Tag.Child [i].Child [j].Child [k].Value
                    else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                     then begin
                           for l := 0 to Length (XML.Tag.Child [i].Child [j].Child [k].Child)-1
                            do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                             then SZV6Arr [SvedCounter-1].SurName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                             else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                              then SZV6Arr [SvedCounter-1].Name := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                              else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name=''
                               then SZV6Arr [SvedCounter-1].FatherName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value;
                          end
                      else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                       then begin
                             for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                              do if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then GName := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value
                              else if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then Socr := XML.Tag.Child [i].Child [j].Child [k].Child [l].Value;
                             if (GName <> '') and (Socr <> '')
                              then begin
                                    Inc (StageCounter);
                                    SetLength (SZV6Arr [SvedCounter-1].Stages,StageCounter);
                                    LgotCounter := 0;
                                    SZV6Arr [SvedCounter-1].Stages [StageCounter-1] := TSZV6Stage.Create;
                                    for l := Low (XML.Tag.Child [i].Child [j].Child [k].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child)
                                     do if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].StartDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value),FS)
                                     else if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '') then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].EndDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value),FS)
                                     else if (XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = '')
                                      then begin
                                            Inc (LgotCounter);
                                            SetLength (SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots,LgotCounter);
                                            SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1] := TSZV6Lgot.Create;
                                            for m := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child)
                                             do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Name = ''
                                              then for n := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child)
                                               do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                then begin
                                                      for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                       do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = '' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].TUOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                       else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = ''
                                                        then begin
                                                              Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value,c,Code);
                                                              SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].TUCoeff := c;
                                                             end;
                                                     end
                                                else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                 then begin
                                                       for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                        do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name='' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].OUTOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                        else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = '' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].OUTKPS := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value;
                                                      end
                                                 else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                  then begin
                                                        for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                         do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name='' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                         else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                          then begin
                                                                for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                 do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVMonths,Code)
                                                                 else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVDays,Code);
                                                               end
                                                          else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                           then begin
                                                                 for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                  do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVHours,Code)
                                                                  else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].ISVMinutes,Code);
                                                                end;
                                                       end
                                                  else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                   then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].Dekret := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Value
                                                   else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Name = ''
                                                    then begin
                                                          for o := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child)
                                                           do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name='' then SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLOsn := XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value
                                                           else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                            then begin
                                                                  for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                   do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLMonths,Code)
                                                                   else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLDays,Code);
                                                                 end
                                                            else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name=''
                                                             then begin
                                                                   for p := Low (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child) to High (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child)
                                                                    do if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLHours,Code)
                                                                    else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Name = '' then Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Child [p].Value,SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLMinutes,Code);
                                                                  end
                                                             else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Name = ''
                                                              then begin
                                                                    Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Child [m].Child [n].Child [o].Value,c,Code);
                                                                    SZV6Arr [SvedCounter-1].Stages [StageCounter-1].Lgots [LgotCounter-1].VLDS := c;
                                                                   end;
                                                         end;
                                           end;
                                   end;
                             //  -  
                            end
                       //     
                       else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                        then begin
                              for l := 0 to Length (XML.Tag.Child [i].Child [j].Child [k].Child) - 1 do
                               if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                then begin
                                      Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                      SZV6Arr [SvedCounter-1].NS := c;
                                     end
                                else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                then begin
                                      Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                      SZV6Arr [SvedCounter-1].US := c;
                                     end;
                             end
                        else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                         then begin
                               for l := 0 to Length (XML.Tag.Child [i].Child [j].Child [k].Child) - 1 do
                                if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                 then begin
                                       Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                       SZV6Arr [SvedCounter-1].NN := c;
                                      end
                                 else if XML.Tag.Child [i].Child [j].Child [k].Child [l].Name = ''
                                 then begin
                                       Val (XML.Tag.Child [i].Child [j].Child [k].Child [l].Value,c,Code);
                                       SZV6Arr [SvedCounter-1].UN := c;
                                      end;
                              end
                          else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                           then SZV6Arr [SvedCounter-1].ZapDate := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Value),FS)
                           else if (XML.Tag.Child [i].Child [j].Child [k].Name = '')
                            then SZV6Arr [SvedCounter-1].SostDateNa := StrToDate (trim (XML.Tag.Child [i].Child [j].Child [k].Value),FS);
                 end;
      end;
 XML.Destroy;
end;

end.
