unit sverkaptk;

//  VL:
// Copyright (C) 2013  . .

//   

interface

uses Classes,pfreqs,szv6,protptk;

type

 //  
 TPTKSverkaApp = class
                  // 
                  PTKFileName  : ANSIString; //       
                  StrName      : ANSIString; //  
                  RegNums      : ANSIString; // ()   
                  ISPath       : ANSIString; //    
                  SubDirs      : Boolean;    //   
                  ProtFileName : ANSIString; //   
                  constructor Create;
                  destructor Destroy;
                 private
                  //  ,   
                  IntRegNums   : TStringList;        //   
                  Req          : TPFRReq;            //  
                  Prot         : TPTKProt;           // 
                  PTKFileYear  : integer;            // 
                  PTKFilePer   : integer;            // 
                  ISYear,ISPer : integer;            //     . 
                  ISList       : array of TSZV6File; //  . 
                  procedure MakeRNL;                 //        RegNums
                  procedure ISRead (checkReqs : Boolean); //        
                  procedure ScanDir (Path : string; checkReqs : Boolean); //    - 
                 public
                  ErrorMsg     : ANSIString;         //   
                  // 
                  function GetReqs : Boolean;        //           
                  function Start : Boolean;          //   
                 end;

implementation

uses SysUtils,funcs,ptkconstants;

constructor TPTKSverkaApp.Create;
begin
 IntRegNums := TStringList.Create;
 SetLength (ISList,0);
 Prot := TPTKProt.Create;
end;

destructor TPTKSverkaApp.Destroy;
var
 i : integer;
begin
 Prot.Destroy;
 if Length (ISList) > 0
  then begin
        for i := 0 to Length (ISList) - 1 do if ISList [i] <> nil then ISList [i].Destroy;
        SetLength (ISList,0);
       end;
 inherited Destroy;
end;

//     
procedure TPTKSverkaApp.MakeRNL;
var
 i : integer;
 s : ANSIString;
begin
 IntRegNums.Clear;
 if RegNums <> ''
  then begin
        s := '';
        for i := 1 to Length (RegNums)
         do if RegNums [i] = ','
          then begin
                s := trim (s);
                if s <> ''
                 then begin
                       IntRegNums.Add (s);
                       s := '';
                      end;
               end
          else s := s + RegNums [i];
        s := trim (s);
        if s <> '' then IntRegNums.Add (s);
       end;
end;


procedure TPTKSverkaApp.ScanDir (Path: string; checkReqs : Boolean);
var
 f  : TSZV6File;
 SR : TSearchRec;
begin
 //    
 if SubDirs
  then begin
        if FindFirst (Path+'*',faDirectory,SR) = 0
         then begin
               repeat
                if ((SR.Attr and faDirectory) <> 0)
                 then if SR.Name [1] <> '.'
                  then ScanDir (Path+SR.Name+'\',checkReqs);
               until FindNext (SR) <> 0;
               FindClose (SR);
              end;
       end;
 //   
 if FindFirst (Path+'PFR-700-Y-????-ORG-*.xml',faAnyFile,SR) = 0
  then begin
        repeat
         if (SR.Attr and (faDirectory + faVolumeID)) = 0
          then begin
                f := TSZV6File.Create;
                f.FileName := Path+SR.Name;
                //   ,     
                if f.Read
                 then begin
                       //   ,  -1,      ,    
                       if (((IntRegNums.IndexOf (f.StrNumb) <> -1) and (f.SvedType = '') and ((f.VidFormy='-6-1') or (f.VidFormy='-6-2') or (f.VidFormy='-6-4')) and (f.OtYear = isYear) and (f.OtPer = isPer)) or (not checkReqs))
                        then begin
                              SetLength (ISList,Length (ISList) + 1);
                              ISList [Length (ISList) - 1] := f;
                             end
                        //    
                        else f.Destroy;
                      end
                 //    
                 else f.Destroy;
               end
        until FindNext(SR) <> 0;
        FindClose (SR);
       end;
end;

//   . 
procedure TPTKSverkaApp.ISRead (checkReqs : Boolean);
var
 s : ANSIString;
begin
 //  -     
 // 
 SetLength (ISList,0);
 //  
 if ISPath [Length (ISPath)] = '\' then ScanDir (ISPath,checkReqs)
  else begin
        if ISPath = '' then ScanDir ('.\',checkReqs)
        else ScanDir (ISPath+'\',checkReqs);
       end;
end;

//      
function TPTKSverkaApp.GetReqs : Boolean;
var
 SL : TStringList;
 i  : integer;
begin
 //      
 ErrorMsg := '';
 Result := True;
 StrName := '';
 RegNums := '';
 //     . 
 if not DirectoryExists (ISPath)
  then begin
        ErrorMsg := '   .   .';
        Result := False;
        Exit;
       end;
 //   
 ISRead (False);
 //    ,   
 if Length (ISList) = 0
  then begin
        ErrorMsg := '      .';
        Result := False;
        Exit;
       end;
 SL := TStringList.Create;
 SL.Clear;
 for i := 0 to Length (ISList) - 1
  do begin
      StrName := ISList [i].StrBriefName;
      if SL.IndexOf (ISList [i].StrNumb) = -1
      then begin
            SL.Add (ISList [i].StrNumb);
            if Regnums <> '' then RegNums := RegNums + ',';
            Regnums := RegNums + ISList [i].StrNumb;
           end;
     end;
 SL.Free;
end;

//   - 
function TPTKSverkaApp.Start : Boolean;
var
 i,j : integer;
 s   : ANSIString;
begin
 //    
 ErrorMsg := '';
 Result := True;
 //   
 //   
 if not FileExists (PTKFileName)
  then begin
        ErrorMsg := '     .';
        Result := False;
        Exit;
       end;
 //    . 
 if not DirectoryExists (ISPath)
  then begin
        ErrorMsg := '   .   .';
        Result := False;
        Exit;
       end;
 //    
 MakeRNL;
 //     ,   
 if IntRegNums.Count = 0
  then begin
        ErrorMsg := '     .';
        Result := False;
        Exit;
       end;
 //    
 if not Req.Read (PTKFileName)
  then begin
        ErrorMsg := Req.ErrorMsg;
        Result := False;
        Exit;
       end;
 //        
 PTKFileYear := 0;
 PTKFilePer := 0;
 for i := 0 to Length (Req.Recs) - 1
  do if IsPeriod1Less (PTKFileYear,PTKFilePer,Req.Recs [i].LastYear,Req.Recs [i].LastPer)
   then begin
         PTKFileYear := Req.Recs [i].LastYear;
         PTKFilePer := Req.Recs [i].LastPer;
        end;
 //    
 Prot.PFRFilePer := strPeriod (PTKFileYear,PTKFilePer);
 //  ,   -     
 //      (      )
 ISYear := PTKFileYear;
 ISPer := PTKFilePer;
 if IsYear = 2010
  then begin
        if ISPer = 2
         then begin
               ISPer := 1;
               ISYear := ISYear + 1;
              end
         else ISPer := ISPer + 1;
       end
  else begin
        if ISPer = 4
         then begin
               ISPer := 1;
               ISYear := ISYear + 1;
              end
         else ISPer := ISPer + 1;
       end;
 //    
 ISRead (True);
 //     ,   
 if Length (ISList) = 0
  then begin
        ErrorMsg := '        .      .';
        Result := False;
        Exit;
       end;
 //   - 
 //            
 Prot.ProgLink := ProgLink;
 Prot.ProgVersion := Version;
 Prot.DebugBuild := DebugBuild;
 Prot.BriefName := StrName;
 Prot.RegNumb := RegNums;
 Prot.PFRFileName := PTKFileName;
 Prot.PFRFileDate := Req.SostDate;
 if Req.ReqType = 1 then Prot.PFRFileType := '12.18'
  else Prot.PFRFileType := '12.32';
 Prot.CalcYear := Req.Year;
 Prot.CalcPer := Req.Quarter;
 //    -     
 for i := 0 to Length (Req.Recs) - 1
  do begin
      //   
      s := Req.Recs [i].SurName+' '+Req.Recs [i].Name;
      if Req.Recs [i].FatherName <> '' then s := s + ' ' + Req.Recs [i].FatherName;
      // 
      Prot.AddPTKSved (Req.Recs [i].NPP,SNILSToNumber (Req.Recs [i].StrNumb),s,Req.Recs [i].LastYear,Req.Recs [i].LastPer,Req.Recs [i].SS,Req.Recs [i].SN);
     end;
 //   
 //  
 for i := 0 to Length (ISList) - 1
  do begin
      //       
      Prot.AddFile (ISList [i].FileName,ISList [i].VidFormy,ISList [i].OtYear,ISList [i].OtPer,ISList [i].DogType,ISList [i].CatCode);
      //     
      for j := 0 to Length (ISList [i].SZV6Arr) - 1
       do begin
           //   
           s := ISList [i].SZV6Arr [j].SurName+' '+ ISList [i].SZV6Arr [j].Name;
           if ISList [i].SZV6Arr [j].FatherName <> '' then s := s + ' ' + ISList [i].SZV6Arr [j].FatherName;
           // 
           Prot.AddISSved (ISList [i].PackNumb,ISList [i].SZV6Arr [j].NumInPack,SNILSToNumber (ISList [i].SZV6Arr [j].StrNumb),s,ISList [i].SZV6Arr [j].NS,ISList [i].SZV6Arr [j].US,ISList [i].SZV6Arr [j].NN,ISList [i].SZV6Arr [j].UN);
          end;
     end;
 //  
 Prot.CalcItogs;
 //    
 Prot.Sort;
 //  
 try
  Prot.makeHTML (ProtFileName);
 except
  ErrorMsg := '     '+ProtFileName;
  Result := False;
 end;
end;

end.
