unit protptk;

//  VL:
// Copyright (C) 2013  . .

//    

interface

type


 //       
 TPTKProtFileRec = record
                    FileName : ANSIString;     //  
                    FormType : ANSIString;     //  
                    OtYear   : integer;        //  
                    OtPer    : integer;        //  
                    CatCode  : ANSIString;     //    
                    DogType  : ANSIString;     //  
                   end;

 //        
 TPTKProtMainRec = record
                    SNILS           : string [11];     //  ( )
                    FIO             : string [150];    //   
                    QueryNumber     : integer;         //  /   
                    QueryLastPer    : ANSIString;      //       
                    QueryLastPerErr : Boolean;         //        -  
                    FileNumber      : ANSIString;      //        
                    SSExists        : Boolean;         //     -      
                    SSS             : Currency;        //       
                    SSSErr          : Boolean;         //        -  
                    CExists         : Boolean;         // / -   . 
                    CNS             : Currency;        //    
                    CUS             : Currency;        //    
                    ESS             : Currency;        //     
                    ESSErr          : integer;         //      -  
                    SSN             : Currency;        //       
                    SSNErr          : Boolean;         //        -  
                    CNN             : Currency;        //    
                    CUN             : Currency;        //    
                    ESN             : Currency;        //     
                    ESNErr          : integer;         //      -  
                   end;

 TPTKProt = class
             ProgLink    : ANSIString;               //   
             ProgVersion : ANSIString;               //  
             DebugBuild  : Boolean;                  //   
             BriefName   : ANSIString;               //  
             RegNumb     : ANSIString;               //  
             CalcYear    : integer;                  //   
             CalcPer     : integer;                  //   
             PFRFileName : ANSIString;               //     
             PFRFileType : ANSIString;               //   
             PFRFileDate : ANSIString;               // ,      
             PFRFilePer  : ANSIString;               //      
             constructor Create;
             destructor Destroy;
            private
             Files       : array of TPTKProtFileRec; //    . 
             Recs        : array of TPTKProtMainRec; //  
             procedure Clear;
             function RecIndex (SNILS,FIO : ANSIString) : integer;
            public
             procedure AddFile (FileName,FormType : ANSIString; OtYear,OtPer : integer; DogType,CatCode : ANSIString);
             procedure AddPTKSved (NPP : integer; SNILS,FIO : ANSIString; LastYear,LastPer : integer; SS,SN : Currency);
             procedure AddISSved (PackNumb,NumInPack : integer; SNILS,FIO : ANSIString; NS,US,NN,UN : Currency);
             procedure CalcItogs;
             procedure Sort;
             procedure makeHTML (FileName : ANSIString);
            end;

implementation

uses SysUtils,funcs;

//   TPTKProt

constructor TPTKProt.Create;
begin
 Clear;
end;

destructor TPTKProt.Destroy;
begin
 Clear;
 inherited Destroy;
end;

//   
procedure TPTKProt.Clear;
begin
 SetLength (Files,0);
 SetLength (Recs,0);
end;

// ,     ;   ,  ,     
function TPTKProt.RecIndex (SNILS,FIO : ANSIString) : integer;
var
 i : integer;
begin
 Result := -1;
 if Length (Recs) > 0
  then for i := 0 to Length (Recs) - 1
   do if Recs [i].SNILS = SNILS
    then begin
          Result := i;
          Recs [Result].FIO := FIO;
          Break;
         end;
 if Result = -1
  then begin
        SetLength (Recs,Length (Recs) + 1);
        Result := Length (Recs) - 1;
        Recs [Result].SNILS := SNILS;
        Recs [Result].FIO := FIO;
        with Recs [Result]
         do begin
             QueryNumber := 0;
             QueryLastPer := '-';
             QueryLastPerErr := False;
             FileNumber := '-';
             SSExists := False;
             CExists := False;
             SSS := 0;
             SSSErr := False;
             CNS := 0;
             CUS := 0;
             ESS := 0;
             ESSErr := 0;
             SSN := 0;
             SSNErr := False;
             CNN := 0;
             CUN := 0;
             ESN := 0;
             ESNErr := 0;
            end;
       end;
end;

//      
procedure TPTKProt.AddFile (FileName: AnsiString; FormType: AnsiString; OtYear: Integer; OtPer: Integer; DogType,CatCode: AnsiString);
begin
 SetLength (Files,Length (Files) + 1);
 Files [Length (Files) - 1].FileName := FileName;
 Files [Length (Files) - 1].FormType := FormType;
 Files [Length (Files) - 1].OtYear := OtYear;
 Files [Length (Files) - 1].OtPer := OtPer;
 Files [Length (Files) - 1].DogType := DogType;
 Files [Length (Files) - 1].CatCode := CatCode;
end;

//    
procedure TPTKProt.AddPTKSved (NPP: Integer; SNILS: AnsiString; FIO: AnsiString; LastYear,LastPer : integer; SS: Currency; SN: Currency);
var
 i : integer;
begin
 i := RecIndex (SNILS,FIO);
 Recs [i].QueryNumber := NPP;
 Recs [i].QueryLastPer := strPeriod (LastYear,LastPer);
 Recs [i].QueryLastPerErr := IsPeriod1Less (LastYear,LastPer,CalcYear,CalcPer);
 Recs [i].SSExists := True;
 Recs [i].SSS := 0 - SS;
 Recs [i].SSSErr := (SS > 0);
 Recs [i].SSN := 0 - SN;
 Recs [i].SSNErr := (SN > 0);
end;

//    
procedure TPTKProt.AddISSved (PackNumb: Integer; NumInPack: Integer; SNILS: AnsiString; FIO: AnsiString; NS: Currency; US: Currency; NN: Currency; UN: Currency);
var
 i : integer;
begin
 // .       ,    ,    ,  
 i := RecIndex (SNILS,FIO);
 if Recs [i].FileNumber <> ''
  then if Recs [i].FileNumber = '-' then Recs [i].FileNumber := '' else Recs [i].FileNumber := Recs [i].FileNumber + ',';
 Recs [i].FileNumber := Recs [i].FileNumber + IntToStr (PackNumb)+'/'+IntToStr (NumInPack);
 Recs [i].CExists := True;
 Recs [i].CNS := Recs [i].CNS + NS;
 Recs [i].CUS := Recs [i].CUS + US;
 Recs [i].CNN := Recs [i].CNN + NN;
 Recs [i].CUN := Recs [i].CUN + UN;
end;

//      
procedure TPTKProt.CalcItogs;
var
 i : integer;
begin
 if Length (Recs) > 0
  then for i := 0 to Length (Recs) - 1
   do with Recs [i]
    do begin
        ESS := SSS + CNS - CUS;
        if ESS < 0 then ESSErr := 2
        else if (ESS > 0) and not CExists then ESSErr := 1;
        ESN := SSN + CNN - CUN;
        if ESN < 0 then ESNErr := 2
        else if (ESN > 0) and not CExists then ESNErr := 1;
       end;
end;

//     
procedure TPTKProt.Sort;
var
 i   : integer;
 Rec : TPTKProtMainRec;
 b   : Boolean;
begin
 if Length (Recs) > 1
  then repeat
        b := False;
        for i := 0 to Length (Recs) - 2
         do if Recs [i].FIO > Recs [i+1].FIO
          then begin
                b := True;
                Rec := Recs [i];
                Recs [i] := Recs [i+1];
                Recs [i+1] := Rec;
               end;
       until b = False;
end;

procedure TPTKProt.makeHTML (FileName: AnsiString);
var
 f                   : TextFile;
 i,i1,i2             : integer;
 PackIndex           : string;
 s                   : string;
 Comment             : string;
begin
 //  
 AssignFile (f,FileName);
 rewrite (f);
 //  
 writeln (f,'<html>');
 writeln (f,' <head>');
 writeln (f,'  <meta http-equiv="Content-Type" content="text/html;charset=windows-1251">');
 writeln (f,'  <title>'+BriefName+' -         </title>');
 writeln (f,'  <script type="text/javascript">');
 writeln (f,'  <!--');
 writeln (f,'  function toggleFilelist()');
 writeln (f,'   {');
 writeln (f,'    if (document.getElementById ("filelist").style.display == "")');
 writeln (f,'     {');
 writeln (f,'      document.getElementById ("filelist").style.display = "none";');
 writeln (f,'      document.getElementById ("filespan").innerHTML = "";');
 writeln (f,'     }');
 writeln (f,'    else');
 writeln (f,'     {');
 writeln (f,'      document.getElementById ("filelist").style.display = "";');
 writeln (f,'      document.getElementById ("filespan").innerHTML = "";');
 writeln (f,'     }');
 writeln (f,'    // return false;');
 writeln (f,'   }');
 writeln (f,'  // -->');
 writeln (f,'  </script>');
 writeln (f,'  <style type="text/css">');
 writeln (f,'   #ta td');
 writeln (f,'    {');
 writeln (f,'     border: 1px solid black;');
 writeln (f,'     font-family: Arial;');
 writeln (f,'     text-align: center;');
 writeln (f,'     font-size: 10pt;');
 writeln (f,'     vertical-align: center;');
 writeln (f,'    }');
 writeln (f,'   .error');
 writeln (f,'    {');
 writeln (f,'     color: red;');
 writeln (f,'    }');
 writeln (f,'  </style>');
 writeln (f,' </head>');
 writeln (f,' <body>');
 //  
 writeln (f,'  <h2>         </h2>');
 write (f,'  <p> <a href="'+ProgLink+'" target="_blank">VL:</a><br/>'+ProgVersion);
 if DebugBuild then write (f,'<br/><font color="#FF0000"><b>   </b></font>');
 writeln (f,'</p>');
 writeln (f,'  <h3>  :</h3>');
 writeln (f,'  <p> : '+BriefName+'</p>');
 writeln (f,'  <p>   : '+RegNumb+'</p>');
 writeln (f,'  <p>    : '+DateToStr (Date)+' '+TimeToStr (Time)+'</p>');
 writeln (f,'  <h3>   :</h3>');
 //      
 writeln (f,'  <p>   : '+PFRFileName+' ,  '+PFRFileType+'    '+PFRFileDate+'</p>');
 writeln (f,'  <p>      : '+PFRFilePer+'</p>');
 //   
 writeln (f,'<p>    :</p>');
 writeln (f,'  <ul>');
 for i := 0 to Length (Files) - 1
  do with Files [i]
   do begin
       write (f,'<li>'+FileName+' - '+FormType+'  '+ strPeriod (OtPer,OtYear));
       if FormType = '-6-4' then write (f,', '+DogType+' ,  '+CatCode);
       writeln (f,'</li>');
      end;
 writeln (f,'  </ul>');
 // 
 writeln (f,'   <h3> :</h3>');
 writeln (f,'   <table cellpadding="0" cellspacing="0" id="ta">');
 // 2  
 writeln (f,'    <tr>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2> /</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2></td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp;, , &nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp; /  &nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp;<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" rowspan=2>&nbsp; /  &nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold" colspan="4"> </td>');
 writeln (f,'     <td style="font-weight: bold" colspan="4"> </td>');
 writeln (f,'     <td style="font-weight: bold" colspan="3"></td>');
 writeln (f,'    </tr>');
 writeln (f,'    <tr>');
 writeln (f,'     <td style="font-weight: bold">&nbsp; <br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp; <br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;.<br/>&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'     <td style="font-weight: bold">&nbsp;&nbsp;</td>');
 writeln (f,'    </tr>');
 //    
 for i := 0 to Length (Recs) - 1
  do begin
      writeln (f,'    <tr>');
      writeln (f,'     <td style="text-align: right">'+IntToStr (i+1)+'</td>');
      writeln (f,'     <td>'+strForHTML (NumberToSNILS (Recs [i].SNILS))+'</td>');
      writeln (f,'     <td style="text-align: left">'+strForHTML (Recs [i].FIO)+'</td>');
      write (f,'     <td>');
      if Recs [i].SSExists then write (f,Recs [i].QueryNumber) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].SSExists then if Recs [i].QueryLastPerErr then write (f,' class="error"');
      write (f,'>');
      if Recs [i].SSExists then write (f,strForHTML (Recs [i].QueryLastPer)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,Recs [i].FileNumber) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].SSExists then if Recs [i].SSSErr then write (f,' class="error"');
      write (f,'>');
      if Recs [i].SSExists then write (f,f2s (Recs [i].SSS)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CNS)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CUS)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].ESSErr <> 0 then write (f,' class="error"');
      writeln (f,'>'+f2s (Recs [i].ESS) +'</td>');
      write (f,'     <td');
      if Recs [i].SSExists then if Recs [i].SSNErr then write (f,' class="error"');
      write (f,'>');
      if Recs [i].SSExists then write (f,f2s (Recs [i].SSN)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CNN)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td>');
      if Recs [i].CExists then write (f,f2s (Recs [i].CUN)) else write (f,'-');
      writeln (f,'</td>');
      write (f,'     <td');
      if Recs [i].ESNErr <> 0 then write (f,' class="error"');
      writeln (f,'>'+f2s (Recs [i].ESN) +'</td>');
      write (f,'     <td class="error">');
      if Recs [i].QueryLastPerErr then write (f,'') else write (f,'&nbsp;');
      writeln (f,'</td>');
      write (f,'     <td class="error">');
      if Recs [i].ESSErr = 1 then write (f,'')
      else if Recs [i].ESSErr = 2 then write (f,'')
      else write (f,'&nbsp;');
      writeln (f,'</td>');
      write (f,'     <td class="error">');
      if Recs [i].ESNErr = 1 then write (f,'')
      else if Recs [i].ESNErr = 2 then write (f,'')
      else write (f,'&nbsp;');
      writeln (f,'</td>');
      writeln (f,'    </tr>');
     end;
 //  
 writeln (f,'   </table>');
 //  
 writeln (f,'   <h3> :</h3>');
 writeln (f,'   <ul>');
 writeln (f,'    <li><b></b> -   (  , .     );</li>');
 writeln (f,'    <li><b></b> - ;</li>');
 writeln (f,'    <li><b></b> -        .</li>');
 writeln (f,'   </ul>');
 //  
 writeln (f,' </body>');
 writeln (f,'</html>');
 CloseFile (f);
end;

end.
