unit pfreqs;

//  VL:
// Copyright (C) 2013  . .

//     12.18  12.32  Excel-

interface

type

 //   
 TReqRec = record
            NPP        : integer;     //  /
            RegNumb    : string [14]; // 
            StrNumb    : string [11]; // 
            SurName    : string [50]; // 
            Name       : string [50]; // 
            FatherName : string [50]; // 
            NS         : Currency;    //  -  
            US         : Currency;    //  -  
            NN         : Currency;    //  -  
            UN         : Currency;    //  -  
            SS         : Currency;    //  -  
            SN         : Currency;    //  -  
            LNS        : Currency;    //    -  
            LUS        : Currency;    //    -  
            LNN        : Currency;    //    -  
            LUN        : Currency;    //    -  
            LastYear   : integer;     //  
            LastPer    : integer;     //  
           end;

 //    
 TPFRReq = object
            ReqType  : integer;          //   (1 - 12.18, 2 - 12.32)
            Quarter  : integer;          //  
            Year     : integer;          //  
            SostDate : ANSIString;       // ,      
            ErrorMsg : ANSIString;       //   
            Recs     : array of TReqRec; //  
            function Read (FileName : ANSIString) : Boolean; //  
           end;

implementation

uses Office,SysUtils,xmlwork,funcs;

//    

//  
function TPFRReq.Read (FileName: AnsiString) : Boolean;
var
 s,s1  : ANSIString;
 XLS   : TXLSData;
 i,j,c : integer;
 r     : real;
begin
 // 
 SetLength (Recs,0);
 ErrorMsg := '';
 SostDate := '';
 //        
 s1 := UpperCase (ExtractFileName (FileName));
 s := Copy (s1,1,10);
 if s = 'R002000228'
  then begin
        //  12.18
        ReqType := 1;
        //     -  0
        Year := 0;
        Quarter := 0;
       end
 else if s = 'R002000307'
  then begin
        //  12-32
        ReqType := 2;
        //     
        //   ,   
        try
         Year := StrToInt (Copy (s1,27,4));
         Quarter := StrToInt (Copy (s1,25,1));
        except
         ErrorMsg := '       12.32.   .';
         Result := False;
         Exit;
        end;
       end
 else begin
       // 
       ErrorMsg := '   .';
       Result := False;
       Exit;
      end;
 //     
 if not XLS.Init
  then begin
        //    
        ErrorMsg := '    Microsoft Office  OpenOffice  .    .';
        Result := False;
        Exit;
       end
  else if not XLS.Open (FileName)
   then begin
         ErrorMsg := '    . ,      .';
         Result := False;
         XLS.Done;
         Exit;
        end
  else begin
        //   (  ,  , )
        XLS.SetActiveSheet (1);
        //  ,      
        s := XLS.GetCellValue ('R1C1');
        SostDate := Copy (s,Length (s) - 9,10);
        //  i -  
        //      
        i := 3;
        while XLS.GetCellValue ('R'+IntToStr (i)+'C1') <> ''
         do try
             SetLength (Recs,Length (Recs) + 1);
             with Recs [Length (Recs) - 1]
              do begin
                  //  /
                  NPP := StrToInt (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C1'))));
                  // 
                  s := trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C2')));
                  s := VedNuli (s,12);
                  RegNumb := Copy (s,1,3) + '-'+Copy (s,4,3)+'-'+Copy (s,7,6);
                  // 	
                  StrNumb := VedNuli (trim (XLS.GetCellValue ('R'+IntToStr (i)+'C3')),9) + VedNuli (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C4'))),2);
                  // 
                  SurName := trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C5')));
                  // 
                  Name := trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C6')));
                  // 
                  FatherName := trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C7')));
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C8'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  8,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  NS := r;
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C9'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  9,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  US := r;
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C10'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  10,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  NN := r;
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C11'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  11,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  UN := r;
                  //   
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C12'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  12,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  SS := r;
                  //   
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C13'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  13,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  SN := r;
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C14'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  14,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  LNS := r;
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C15'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  15,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  LUS := r;
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C16'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  16,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  LNN := r;
                  //  
                  s := FPReplace (trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C17'))));
                  Val (s,r,c);
                  if c <> 0
                   then begin
                         ErrorMsg := '    '+IntToStr (i)+',  17,  '+s+' .';
                         Result := False;
                         XLS.Close;
                         XLS.Done;
                         Exit;
                        end;
                  LUN := r;
                  //  
                  s := trim (string (XLS.GetCellValue ('R'+IntToStr (i)+'C18')));;
                  LastPer := StrToInt (Copy (s,1,1));
                  LastYear := StrToInt (Copy (s,Length (s) - 3,4));
                 end;
             //     1
             i := i + 1;
            except
             ErrorMsg := '    '+IntToStr (i);
             Result := False;
             XLS.Close;
             XLS.Done;
             Exit;
            end;
        //  
        XLS.Close;
        XLS.Done;
        Result := True;
       end;
end;

end.
