unit funcs;

//  VL:
// Copyright (C) 2013  . .

//  

interface

//       (   )
function SNILSToNumber (SNILS : string) : string;

//        
function NumberToSNILS (Number : string) : string;

//       HTML-
function strForHTML (St : string) : string;

//         HTML-
function f2s (f : Currency) : string;

//         Excel-
function f2s2 (f : Currency) : string;

//       
function strPeriod (year,per : integer) : ANSIString;

//    
function IsPeriod1Less (y1,p1,y2,p2 : integer) : Boolean;

//      
function VedNuli (s : ANSIString; Len : integer) : ANSIString;

//         -     
function FPReplace (s : ANSIString) : ANSIString;

implementation

uses SysUtils;

//       (   )
function SNILSToNumber (SNILS : string) : string;
var
 s : string;
 i : integer;
begin
 if Length (SNILS) <> 14 then SNILSToNumber := SNILS
 else begin
       s := '';
       for i := 1 to Length (SNILS) do if (SNILS [i] >= '0') and (SNILS [i] <= '9') then s := s + SNILS [i];
       SNILSToNumber := s;
      end;
end;

//        
function NumberToSNILS (Number : string) : string;
begin
 Result := Copy (Number,1,3)+'-'+Copy (Number,4,3)+'-'+Copy (Number,7,3)+' '+Copy (Number,10,2);
end;

//       HTML-
function strForHTML (St : string) : string;
var
 s,s1 : string;
 i    : integer;
begin
 s := St;
 if s <> ''
  then begin
        //   
        while s [1] = ' ' do s := Copy (s,2,Length (s)-1);
        //  
        if s <> '' then while s [Length (s)] = ' ' do s := Copy (s,1,Length (s)-1);
        //     
        s1 := s;
        s := '';
        if s1 <> ''
         then for i := 1 to Length (s1)
          do if s1 [i] = ' ' then s := s + '&nbsp;'
           else s := s + s1 [i];
       end;
 Result := '&nbsp;'+s+'&nbsp;';
end;

//         HTML-
function f2s (f : Currency) : string;
var
 s   : string;
begin
 Str (f:15:2,s);
 //   
 while s [1] = ' ' do s := Copy (s,2,Length (s)-1);
 Result := '&nbsp;'+s+'&nbsp';
end;

//         Excel-
function f2s2 (f : Currency) : string;
var
 s   : string;
begin
 Str (f:15:2,s);
 //   
 while s [1] = ' ' do s := Copy (s,2,Length (s)-1);
 Result := s;
end;

//       
function strPeriod (year,per : integer) : ANSIString;
begin
 Result := IntToStr (Per) + ' ';
 if Year = 2010 then Result := Result + '' else Result := Result + '';
 Result := Result + ' ' + IntToStr (Year);
end;

//    
function IsPeriod1Less (y1,p1,y2,p2 : integer) : Boolean;
begin
 Result := False;
 if y1 < y2 then Result := True
 else if y1 = y2 then Result := (p1 < p2);     
end;

//      
function VedNuli (s : ANSIString; Len : integer) : ANSIString;
var
 t : ANSIString;
begin
 t := s;
 while Length (t) < Len do t := '0' + t;
 Result := t;
end;

//         -     
function FPReplace (s : ANSIString) : ANSIString;
var
 i : integer;
begin
 Result := '';
 for i := 1 to Length (s)
  //   (,   . .)   -     
  do if ((s [i] >= '0') and (s [i] <= '9')) or (s [i] = '.') or (s [i] = ',') or (s [i] = '-')
   then if s [i] = ',' then Result := Result + '.'
   else Result := Result + s [i];
end;

end.
