unit sverka;

//       ,    
// Copyright (C) 2011  . .
//     .   
//       ,   vk65  ,    

interface

uses szv6,Classes;

type

 //  
 TOtPer = record
           Year    : integer;
           Quarter : integer;
          end;

 // -
 TSZV6NU = record
            Year      : integer;       // 
            Quarter   : integer;       // 
            Category  : string [4];    // 
            PackIndex : integer;       //  ,    
            Corrected : Boolean;       //  
            NS        : Currency;      //   
            NN        : Currency;      //   
            US        : Currency;      //   
            UN        : Currency;      //   
           end;

 // 
 TSZV6Sotr = class
              StrNumb    : string;           //  
              SurName    : string;           // 
              Name       : string;           // 
              FatherName : string;           // 
              NU         : array of TSZV6NU; // -     
              constructor Create;
              destructor Destroy;
             end;

 //     
 TFileRec = record
             FileName     : string;         //  
             VidFormy     : string [7];     //  
             PackNumb     : LongInt;        //  
             SvedType     : string [15];    //  
             OtYear       : integer;        //  
             OtPer        : integer;        //  
             CorrYear     : integer;        //   
             Year         : integer;
             Per          : integer;
             CorrPer      : integer;        //   
             CatCode      : string [4];     //   
             SostDate     : TDate;          //    
            end;

 //   
 TFileSet = class
             Recs    : array of TFileRec;     //  
             Sotrs   : array of TSZV6Sotr;    // 
             Periods : array of TOtPer;       //  
             constructor Create;
             destructor Destroy;
            private
             procedure AddPeriod (Year,Quarter : integer);
             function sotrIndex (StrNumb : string) : integer;
             function svedIndex (Sotr,Year,Per : integer; Category : string) : integer;
             procedure GetNU (const Sotr,Year,Quarter : integer; var PackIndex : string; var NS,NN,US,UN : Currency);
             function RedPeriodIndex (Sotr : integer) : integer;
            public
             procedure Get (Path,StrNumb : string; Log : TStringList);
             procedure makeHTML (Log : TStringList; ProgramVersion,DebugBuild,ProgramLink,StrName,RegNumb,FileName : string; groupBy : integer);
             procedure makeXLS (Log : TStringList; ProgramVersion,DebugBuild,ProgramLink,StrName,RegNumb,FileName : string; groupBy : integer);
            end;

  //  
  TConfig = object
             FilesPath : string;      //  ()    
             PPPMethod : integer;     //    
             procedure Init;
             procedure Read;
             procedure Save;
            end;

var
 Config : TConfig;

procedure getNumList (Path : string; NameList,NumList : TStringList);

implementation

uses SysUtils,Registry;

const
 RegPath : string = '\Software\VL\SverkaPF';

function f2s (f : Currency) : string;
var
 s   : string;
begin
 Str (f:15:2,s);
 //   
 while s [1] = ' ' do s := Copy (s,2,Length (s)-1);
 f2s := '&nbsp;'+s+'&nbsp';
end;

function f2s2 (f : Currency) : string;
var
 s   : string;
begin
 Str (f:15:2,s);
 //   
 while s [1] = ' ' do s := Copy (s,2,Length (s)-1);
 f2s2 := s;
end;

procedure getCurrentPer (var Year,Quarter : integer);
var
 Y,M,D : word;
begin
 DecodeDate (Date,Y,M,D);
 Year := Y;
 Quarter := Trunc ((M-1) / 3) + 1;
end;

function ToChange (y1,p1 : integer; t1,c1 : string; d1 : TDate; y2,p2 : integer; t2,c2 : string; d2 : TDate) : Boolean;
begin
 Result := False;
 if y1 > y2 then Result := True
 else if y1 = y2
  then if p1 > p2 then Result := True
  else if p1 = p2
   then if (t1 > t2)
    then Result := True
    else if t1 = t2
     then Result := (d1 > d2);
end;

function getPerName (Year,Quarter : integer) : string;
var
 s : string;
begin
 s := IntToStr (Quarter)+' ';
 if Year = 2010 then s := s + '' else s := s + '';
 getPerName := s + ' '+IntToStr (Year)+' .';
end;

function strForHTML (St : string) : string;
var
 s,s1 : string;
 i    : integer;
begin
 s := St;
 if s <> ''
  then begin
        //   
        while s [1] = ' ' do s := Copy (s,2,Length (s)-1);
        //  
        if s <> '' then while s [Length (s)] = ' ' do s := Copy (s,1,Length (s)-1);
        //     
        s1 := s;
        s := '';
        if s1 <> ''
         then for i := 1 to Length (s1)
          do if s1 [i] = ' ' then s := s + '&nbsp;'
           else s := s + s1 [i];
       end;
 strForHTML := '&nbsp;'+s+'&nbsp;';
end;

procedure getNumList (Path : string; NameList,NumList : TStringList);
var
 SR    : TSearchRec;
 f     : TSZV6File;
begin
 NumList.Clear;
 NameList.Clear;
 f := TSZV6File.Create;
 if FindFirst (Path+'PFR-700-Y-????-ORG-*.xml',faHidden+faReadOnly+faArchive ,SR) = 0
  then begin
        repeat
          if (SR.Attr and (faHidden+faReadOnly+faArchive)) = SR.Attr
           then begin
                 f.FileName := Path+SR.Name;
                 if f.Read
                  then begin
                        if NumList.IndexOf (f.StrNumb) = -1
                         then if (f.VidFormy = '-6-1') or (f.VidFormy = '-6-2')
                          then begin
                                if f.StrName <> '' then NameList.Add (f.StrName) else NameList.Add (f.StrBriefName);
                                NumList.Add (f.StrNumb);
                               end;
                       end;
                end;
        until FindNext(SR) <> 0;
        FindClose (SR);
       end;
 f.Destroy;
end;

constructor TFileSet.Create;
begin
 SetLength (Recs,0);
 SetLength (Sotrs,0);
 SetLength (Periods,0);
end;

destructor TFileSet.Destroy;
var
 i : integer;
begin
 if Length (Sotrs) > 0
  then for i := 0 to Length (Sotrs) - 1
   do Sotrs [i].Destroy;
 SetLength (Recs,0);
 SetLength (Sotrs,0);
 SetLength (Periods,0);
end;

procedure TFileSet.AddPeriod (Year,Quarter : integer);
var
 i,i1 : integer;
begin
 i1 := -1;
 if Length (Periods) > 0
  then for i := 0 to Length (Periods)
   do if (Periods [i].Year = Year) and (Periods [i].Quarter = Quarter)
    then i1 := i;
 if i1 = -1
  then begin
        i1 := Length (Periods) + 1;
        SetLength (Periods,i1);
        Dec (i1);
        Periods [i1].Year := Year;
        Periods [i1].Quarter := Quarter;
       end;
end;

function TFileSet.sotrIndex (StrNumb : string) : integer;
var
 i,i1 : integer;
begin
 if Length (Sotrs) = 0
  then sotrIndex := -1
  else begin
        i1 := -1;
        for i := 0 to Length (Sotrs) - 1
         do if Sotrs [i].StrNumb = StrNumb
          then i1 := i;
        sotrIndex := i1;
       end;
end;

function TFileSet.svedIndex (Sotr,Year,Per : integer; Category : string) : integer;
var
 i,i1 : integer;
begin
 if Length (Sotrs [Sotr].NU) = 0
  then svedIndex := -1
  else begin
        i1 := -1;
        for i := 0 to Length (Sotrs [Sotr].NU) - 1
         do if (Sotrs [Sotr].NU [i].Year = Year) and (Sotrs [Sotr].NU [i].Quarter = Per) and (Sotrs [Sotr].NU [i].Category = Category)
          then i1 := i;
        svedIndex := i1;
       end;
end;

procedure TFileSet.GetNU;
var
 i : integer;
begin
 NS := 0;
 NN := 0;
 US := 0;
 UN := 0;
 PackIndex := '';
 if Length (Sotrs [Sotr].NU) > 0
  then for i := 0 to Length (Sotrs [Sotr].NU) - 1
   do if (Sotrs [Sotr].NU [i].Year = Year) and (Sotrs [Sotr].NU [i].Quarter = Quarter)
    then begin
          NS := NS + Sotrs [Sotr].NU [i].NS;
          NN := NN + Sotrs [Sotr].NU [i].NN;
          US := US + Sotrs [Sotr].NU [i].US;
          UN := UN + Sotrs [Sotr].NU [i].UN;
          if PackIndex <> '' then PackIndex := PackIndex + ', ';
          PackIndex := PackIndex + IntToStr (Sotrs [Sotr].NU [i].PackIndex+1);
         end;
end;

function TFileSet.RedPeriodIndex (Sotr : integer) : integer;
var
 i,i1        : integer;
 SS,SN       : Currency;
 NS,NN,US,UN : Currency;
 P           : string;
begin
 i1 := -1;
 SS := 0;
 SN := 0;
 for i := 0 to Length (Periods)-1
  do if i1 = -1
   then begin
         GetNU (Sotr,Periods [i].Year,Periods [i].Quarter,P,NS,NN,US,UN);
         SS := SS + NS - US;
         SN := SN + NN - UN;
         if (SS < 0) or (SN < 0) then i1 := i;
        end;
 RedPeriodIndex := i1;
end;

procedure TFileSet.Get (Path: string; StrNumb: string; Log : TStringList);
var
 Counter,i,i1,i2,i3 : integer;
 SR                 : TSearchRec;
 f                  : TSZV6File;
 s                  : TSZV6Sotr;
 P                  : TFileRec;
 Q                  : TOtPer;
 b,b1               : Boolean;
begin
 f := TSZV6File.Create;
 Log.Clear;
 //      
 Counter := 0;
 SetLength (Recs,Counter);
 SetLength (Sotrs,Counter);
 SetLength (Periods,Counter);
 if FindFirst (Path+'PFR-700-Y-????-ORG-*.xml',faHidden+faReadOnly+faArchive ,SR) = 0
  then begin
        repeat
          if (SR.Attr and (faHidden+faReadOnly+faArchive)) = SR.Attr
           then begin
                 f.FileName := Path+SR.Name;
                 if f.Read
                  then if (f.StrNumb = StrNumb) and ((f.VidFormy = '-6-1') or (f.VidFormy = '-6-2'))
                   then begin
                         Inc (Counter);
                         SetLength (Recs,Counter);
                         with Recs [Counter-1]
                          do begin
                              FileName := Path+SR.Name;
                              VidFormy := f.VidFormy;
                              PackNumb := f.PackNumb;
                              SvedType := f.SvedType;
                              OtYear := f.OtYear;
                              OtPer := f.OtPer;
                              CorrYear := f.CorrYear;
                              CorrPer := f.CorrPer;
                              if SvedType = ''
                               then begin
                                     Year := OtYear;
                                     Per := OtPer;
                                    end
                               else begin
                                     Year := CorrYear;
                                     Per := CorrPer;
                                    end;
                              CatCode := f.CatCode;
                              SostDate := f.SostDate;
                             end;
                         AddPeriod (Recs [Counter-1].Year,Recs [Counter-1].Per);
                        end;
                end;
        until FindNext(SR) <> 0;
        FindClose (SR);
       end;
 //        , 
 if Length (Recs) > 0
         then begin
               //         
               repeat
                b := False;
                for i := 0 to Counter - 2
                 do if ToChange (Recs [i].Year,Recs [i].Per,Recs [i].SvedType,Recs [i].CatCode,Recs [i].SostDate,Recs [i+1].Year,Recs [i+1].Per,Recs [i+1].SvedType,Recs [i+1].CatCode,Recs [i+1].SostDate)
                  then begin
                        b := True;
                        P := Recs [i];
                        Recs [i] := Recs [i+1];
                        Recs [i+1] := P;
                       end;
               until b = False;
               //  
               Counter := 0;
               for i := 0 to Length (Recs) - 1
                do begin
                    f.FileName := Recs [i].FileName;
                    if f.Read
                     then begin
                           for i1 := 0 to Length (f.SZV6Arr)- 1
                            do begin
                                //  i2     ;   ,  
                                i2 := sotrIndex (f.SZV6Arr [i1].StrNumb);
                                if i2 = -1
                                 then begin
                                       Inc (Counter);
                                       SetLength (Sotrs,Counter);
                                       i2 := Counter - 1;
                                       Sotrs [i2] := TSZV6Sotr.Create;
                                      end;
                                //   
                                with Sotrs [i2]
                                 do begin
                                     SurName := f.SZV6Arr [i1].SurName;
                                     Name := f.SZV6Arr [i1].Name;
                                     FatherName := f.SZV6Arr [i1].FatherName;
                                     StrNumb := f.SZV6Arr [i1].StrNumb;
                                    end;
                                //        
                                i3 := svedIndex (i2,Recs [i].Year,Recs [i].Per,Recs [i].CatCode);
                                if i3 = -1
                                 then begin
                                       //   ,  :   ,  ;  
                                       if Recs [i].SvedType = ''
                                        then begin
                                              //  
                                              SetLength (Sotrs [i2].NU,Length (Sotrs [i2].NU)+1);
                                              with Sotrs [i2].NU [Length (Sotrs [i2].NU)-1]
                                               do begin
                                                   Year := Recs [i].Year;
                                                   Quarter := Recs [i].Per;
                                                   Category := Recs [i].CatCode;
                                                   NS := f.SZV6Arr [i1].NS;
                                                   NN := f.SZV6Arr [i1].NN;
                                                   US := f.SZV6Arr [i1].US;
                                                   UN := f.SZV6Arr [i1].UN;
                                                   PackIndex := i;
                                                   Corrected := False;
                                                  end;
                                             end
                                        else Log.Add ('  '+f.SZV6Arr [i1].SurName+' '+f.SZV6Arr [i1].Name+' '+f.SZV6Arr [i1].FatherName+' (  '+f.SZV6Arr [i1].StrNumb+')    '+IntToStr (i+1)+'        .');
                                      end
                                 else begin
                                       //    ,    ,  
                                       if Recs [i].SvedType <> ''
                                        then begin
                                              if Recs [i].SvedType = ''
                                               then with Sotrs [i2].NU [i3]
                                                do begin
                                                    NS := f.SZV6Arr [i1].NS;
                                                    NN := f.SZV6Arr [i1].NN;
                                                    US := f.SZV6Arr [i1].US;
                                                    UN := f.SZV6Arr [i1].UN;
                                                    if Corrected then Log.Add ('  '+f.SZV6Arr [i1].SurName+' '+f.SZV6Arr [i1].Name+' '+f.SZV6Arr [i1].FatherName+' (  '+f.SZV6Arr [i1].StrNumb+')    '+IntToStr (i+1)+'    ,     .  /      '+IntToStr (PackIndex+1))
                                                    else Corrected := True;
                                                    PackIndex := i;
                                                   end
                                               else if Recs [i].SvedType = ''
                                               then with Sotrs [i2].NU [i3]
                                                do begin
                                                    NS := 0;
                                                    NN := 0;
                                                    US := 0;
                                                    UN := 0;
                                                    if Corrected then Log.Add ('  '+f.SZV6Arr [i1].SurName+' '+f.SZV6Arr [i1].Name+' '+f.SZV6Arr [i1].FatherName+' (  '+f.SZV6Arr [i1].StrNumb+')    '+IntToStr (i+1)+'    ,     .  /      '+IntToStr (PackIndex+1))
                                                    else Corrected := True;
                                                    PackIndex := i;
                                                   end;
                                             end
                                        else Log.Add ('  '+f.SZV6Arr [i1].SurName+' '+f.SZV6Arr [i1].Name+' '+f.SZV6Arr [i1].FatherName+' (  '+f.SZV6Arr [i1].StrNumb+')    '+IntToStr (f.PackNumb)+'    .');
                                      end;
                               end;
                          end
                     else Log.Add ('    '+f.FileName);
                   end;
               //          
               if Length (Sotrs) > 0
                then begin
                      //       
                      repeat
                       b := False;
                       for i := 0 to Counter - 2
                        do begin
                            b1 := False;
                            if Sotrs [i].SurName > Sotrs [i+1].SurName then b1 := True
                            else if Sotrs [i].SurName = Sotrs [i+1].SurName
                             then if Sotrs [i].Name > Sotrs [i+1].Name then b1 := True
                             else if Sotrs [i].Name = Sotrs [i+1].Name
                              then b1 := (Sotrs [i].FatherName > Sotrs [i+1].FatherName);
                            if b1
                             then begin
                                   b := True;
                                   s := Sotrs [i];
                                   Sotrs [i] := Sotrs [i+1];
                                   Sotrs [i+1] := s;
                                  end;
                           end;
                      until b = False;
                      //         
                      repeat
                       b := False;
                       for i := 0 to Length (Periods) - 2
                        do begin
                            b1 := False;
                            if Periods [i].Year > Periods [i+1].Year then b1 := True
                            else if Periods [i].Year = Periods [i+1].Year
                             then b1 := (Periods [i].Quarter > Periods [i+1].Quarter);
                            if b1
                             then begin
                                   b := True;
                                   Q := Periods [i];
                                   Periods [i] := Periods [i+1];
                                   Periods [i+1] := Q;
                                  end;
                           end;
                      until b = False;
                     end;
              end;
 // 
 f.Destroy;
end;

procedure TFileSet.makeHTML;
var
 f                   : TextFile;
 i,i1,i2             : integer;
 PackIndex           : string;
 NS,NN,US,UN         : Currency;
 NINS,NINN,NIUS,NIUN : Currency;
 SS,SN               : Currency;

begin
 AssignFile (f,FileName);
 rewrite (f);
 //  
 writeln (f,'<html>');
 writeln (f,' <head>');
 writeln (f,'  <meta http-equiv="Content-Type" content="text/html;charset=windows-1251">');
 writeln (f,'  <title>'+StrName+' -         </title>');
 writeln (f,'  <script type="text/javascript">');
 writeln (f,'  <!--');
 writeln (f,'  function toggleFilelist()');
 writeln (f,'   {');
 writeln (f,'    if (document.getElementById ("filelist").style.display == "")');
 writeln (f,'     {');
 writeln (f,'      document.getElementById ("filelist").style.display = "none";');
 writeln (f,'      document.getElementById ("filespan").innerHTML = "";');
 writeln (f,'     }');
 writeln (f,'    else');
 writeln (f,'     {');
 writeln (f,'      document.getElementById ("filelist").style.display = "";');
 writeln (f,'      document.getElementById ("filespan").innerHTML = "";');
 writeln (f,'     }');
 writeln (f,'    // return false;');
 writeln (f,'   }');
 //        
 if (GroupBy = 1)
  then begin
        writeln (f,'     function togglePeriod (index,visible)');
        writeln (f,'      {');
        writeln (f,'       var d = "";');
        writeln (f,'       if (!visible) d = "none";');
        writeln (f,'       var t = document.getElementById ("ta");');
        writeln (f,'       t.rows [0].cells [index + 2].style.display = d;');
        writeln (f,'       var i = index * 2;');
        writeln (f,'       t.rows [1].cells [i].style.display = d;');
        writeln (f,'       t.rows [1].cells [i+1].style.display = d;');
        writeln (f,'       i = index * 4;');
        writeln (f,'       for (var i1 = 0; i1 < 4; i1++) t.rows [2].cells [i+i1].style.display = d;');
        writeln (f,'       i = index * 12;');
        writeln (f,'       for (i1 = 0; i1 < 12; i1++) t.rows [3].cells [i+i1].style.display = d;');
        writeln (f,'       for (var i2 = 4; i2 < t.rows.length; i2++) for (i1 = 0; i1 < 12; i1++) t.rows [i2].cells [i+i1+2].style.display = d;');
        writeln (f,'      }');
       end;
 writeln (f,'  // -->');
 writeln (f,'  </script>');
 writeln (f,'  <style type="text/css">');
 writeln (f,'   #ta td');
 writeln (f,'    {');
 writeln (f,'     border: 1px solid black;');
 writeln (f,'     font-family: Arial;');
 writeln (f,'     text-align: center;');
 writeln (f,'     font-size: 10pt;');
 writeln (f,'     vertical-align: center;');
 writeln (f,'    }');
 writeln (f,'  </style>');
 writeln (f,' </head>');
 writeln (f,' <body>');
 //  
 writeln (f,'  <h2>         </h2>');
 write (f,'  <p> <a href="'+ProgramLink+'" target="_blank">VL:</a><br/>'+ProgramVersion);
 if DebugBuild <> '' then write (f,'<br/><font color="#FF0000"><b>'+DebugBuild+'</b></font>');
 writeln (f,'</p>');
 writeln (f,'  <p>    : '+DateToStr (Date)+' '+TimeToStr (Time)+'</p>');
 writeln (f,'  <h3>  :</h3>');
 writeln (f,'  <p> : '+StrName+'</p>');
 writeln (f,'  <p>   : '+RegNumb+'</p>');
 writeln (f,'  <p>   .    : ');
 writeln (f,'  <span id="filespan" style="text-decoration: underline; color: blue; cursor: pointer" onClick="javascript: toggleFilelist()"></span>');
 writeln (f,'   <div id="filelist">');
 writeln (f,'    <ol>');
 for i := 0 to Length (Recs) - 1
  do begin
      write (f,'     <li>'+Recs [i].FileName+' ('+Recs [i].VidFormy+' '+Recs [i].SvedType+'  '+getPerName (Recs [i].Year,Recs [i].Per)+',  '+Recs [i].CatCode+')');
      writeln (f,'</li>');
     end;
 writeln (f,'    </ol>');
 writeln (f,'   </div>');
 writeln (f,'  </p>');
 writeln (f,'  <p> :');
 writeln (f,'   <ul>');
 for i := 0 to Length (Periods) - 1
  do if GroupBy=0 then writeln (f,'    <li>'+getPerName (Periods [i].Year,Periods [i].Quarter)+'</li>')
  else writeln (f,'    <li><input type=checkbox checked onClick="javascript: togglePeriod ('+IntToStr (i)+',this.checked)"/>'+getPerName (Periods [i].Year,Periods [i].Quarter)+'</li>');
 writeln (f,'   </ul>');
 writeln (f,'  </p>');
 // ,   ,  
 if Log.Count > 0
  then begin
        writeln (f,'  <h3>  ,   :</h3>');
        for i := 0 to Log.Count - 1
         do writeln (f,'  <p>'+Log.Strings [i]+'</p>');
       end;
 //   -      
 if GroupBy = 0
  then begin
        //    
        writeln (f,'  <table cellpadding=0 cellspacing=0 id="ta">');
        writeln (f,'   <tr>');
        writeln (f,'    <td style="font-weight: bold" rowspan=3>&nbsp;</td>');
        writeln (f,'    <td style="font-weight: bold" rowspan=3>,&nbsp;,&nbsp;</td>');
        writeln (f,'    <td style="font-weight: bold" rowspan=3></td>');
        writeln (f,'    <td style="font-weight: bold" rowspan=3>&nbsp;</td>');
        writeln (f,'    <td style="font-weight: bold" colspan=5>&nbsp;</td>');
        writeln (f,'    <td style="font-weight: bold" colspan=5>&nbsp;</td>');
        writeln (f,'   </tr>');
        writeln (f,'   <tr>');
        writeln (f,'    <td style="font-weight: bold" colspan=2>&nbsp;</td>');
        writeln (f,'    <td style="font-weight: bold" colspan=3>&nbsp;</td>');
        writeln (f,'    <td style="font-weight: bold" colspan=2>&nbsp;</td>');
        writeln (f,'    <td style="font-weight: bold" colspan=3>&nbsp;</td>');
        writeln (f,'   </tr>');
        writeln (f,'   <tr>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'    <td style="font-weight: bold"></td>');
        writeln (f,'   </tr>');
       end
  else begin
        //    
        writeln (f,'  <table cellpadding=0 cellspacing=0 id="ta">');
        writeln (f,'   <tr>                                         ');
        writeln (f,'    <td rowspan=4 style="font-weight: bold"> </td>');
        writeln (f,'    <td rowspan=4 style="font-weight: bold">, , </td>');
        for i := 0 to Length (Periods) - 1
         do writeln (f,'    <td colspan=12 style="font-weight: bold">'+strForHTML (getPerName (Periods [i].Year,Periods [i].Quarter))+'</td>');
        writeln (f,'   </tr>');
        writeln (f,'   <tr>');
        for i := 0 to Length (Periods) - 1
         do begin
             writeln (f,'    <td colspan=6 style="font-weight: bold">&nbsp;</td>');
             writeln (f,'    <td colspan=6 style="font-weight: bold">&nbsp;</td>');
            end;
        writeln (f,'   </tr>');
        writeln (f,'   <tr>');
        for i := 1 to Length (Periods) *2
         do begin
             writeln (f,'    <td colspan=3 style="font-weight: bold"> </td>');
             writeln (f,'    <td colspan=3 style="font-weight: bold"> </td>');
            end;
        writeln (f,'   </tr>');
        writeln (f,'   <tr>');
        for i := 1 to Length (Periods) *2
         do begin
             writeln (f,'    <td style="font-weight: bold">  ( )</td>');
             writeln (f,'    <td style="font-weight: bold"></td>');
             writeln (f,'    <td style="font-weight: bold"></td>');
             writeln (f,'    <td style="font-weight: bold"></td>');
             writeln (f,'    <td style="font-weight: bold"></td>');
             writeln (f,'    <td style="font-weight: bold"></td>');
            end;
        writeln (f,'   </tr>');
       end;
 //  
 // -    
 if GroupBy=0
  then begin
        for i := 0 to Length (Sotrs)-1
         do begin
             i2 := RedPeriodIndex (i);
             writeln (f,'   <tr>');
             write (f,'    <td style="text-align: center');
             if i2 > -1 then write (f,'; color: red;');
             writeln (f,'" rowspan='+IntToStr (Length (Periods))+'>'+strForHTML (Sotrs [i].StrNumb)+'</td>');
             write (f,'    <td style="text-align: left');
             if i2 > -1 then write (f,'; color: red;');
             writeln (f,'" rowspan='+IntToStr (Length (Periods))+'>'+strForHTML (Sotrs [i].SurName+' '+Sotrs [i].Name+' '+Sotrs [i].FatherName)+'</td>');
             NINS := 0;
             NIUS := 0;
             NINN := 0;
             NIUN := 0;
             for i1 := 0 to Length (Periods) - 1
              do begin
                  GetNU (i,Periods [i1].Year,Periods [i1].Quarter,PackIndex,NS,NN,US,UN);
                  NINS := NINS + NS;
                  NIUS := NIUS + US;
                  SS := NINS - NIUS;
                  NINN := NINN + NN;
                  NIUN := NIUN + UN;
                  SN := NINN - NIUN;
                  if PackIndex = '' then PackIndex := '-';
                  if i1 > 0 then writeln (f,'   <tr>');
                  writeln (f,'    <td style="text-align: left">'+strForHTML (getPerName (Periods [i1].Year,Periods [i1].Quarter))+'</td>');
                  writeln (f,'    <td style="text-align: center">'+PackIndex+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NS)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (US)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NINS)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NIUS)+'</td>');
                  write (f,'    <td style="text-align: center');
                  if (SS < 0) then write (f,'; color: red;');
                  writeln (f,'">'+f2s (SS)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NN)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (UN)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NINN)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NIUN)+'</td>');
                  write (f,'    <td style="text-align: center');
                  if (SN < 0) then write (f,'; color: red;');
                  writeln (f,'">'+f2s (SN)+'</td>');
                  writeln (f,'   </tr>');
                 end;
            end;
       end
  else begin
        //    
        for i := 0 to Length (Sotrs)-1
         do begin
             i2 := RedPeriodIndex (i);
             writeln (f,'   <tr>');
             write (f,'    <td style="text-align: center');
             if i2 > -1 then write (f,'; color: red;');
             writeln (f,'">'+strForHTML (Sotrs [i].StrNumb)+'</td>');
             write (f,'    <td style="text-align: left');
             if i2 > -1 then write (f,'; color: red;');
             writeln (f,'">'+strForHTML (Sotrs [i].SurName+' '+Sotrs [i].Name+' '+Sotrs [i].FatherName)+'</td>');
             NINS := 0;
             NIUS := 0;
             NINN := 0;
             NIUN := 0;
             for i1 := 0 to Length (Periods) - 1
              do begin
                  GetNU (i,Periods [i1].Year,Periods [i1].Quarter,PackIndex,NS,NN,US,UN);
                  NINS := NINS + NS;
                  NIUS := NIUS + US;
                  SS := NINS - NIUS;
                  NINN := NINN + NN;
                  NIUN := NIUN + UN;
                  SN := NINN - NIUN;
                  if PackIndex = '' then PackIndex := '-';
                  writeln (f,'    <td style="text-align: center">'+PackIndex+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NS)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (US)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NINS)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NIUS)+'</td>');
                  write (f,'    <td style="text-align: center');
                  if (SS < 0) then write (f,'; color: red;');
                  writeln (f,'">'+f2s (SS)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+PackIndex+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NN)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (UN)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NINN)+'</td>');
                  writeln (f,'    <td style="text-align: center">'+f2s (NIUN)+'</td>');
                  write (f,'    <td style="text-align: center');
                  if (SN < 0) then write (f,'; color: red;');
                  writeln (f,'">'+f2s (SN)+'</td>');
                 end;
             writeln (f,'   </tr>');
            end;
       end;
 //  
 writeln (f,'  </table>');
 writeln (f,' </body>');
 writeln (f,'</html>');
 CloseFile (f);
end;

procedure TFileSet.makeXLS;
var
 f                   : TextFile;
 i,i1,i2             : integer;
 PackIndex           : string;
 NS,NN,US,UN         : Currency;
 NINS,NINN,NIUS,NIUN : Currency;
 SS,SN               : Currency;

begin
 AssignFile (f,FileName);
 rewrite (f);
 //  
 writeln (f,'<?xml version="1.0" encoding="windows-1251"?>');
 writeln (f,'<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet">');
 writeln (f,'<DocumentProperties Author="" LastAuthor="" Created="" LastSaved="" Company="" Version="1.0" />');
 writeln (f,'<Styles>');
 writeln (f,'<Style ss:ID="Bold" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">');
 writeln (f,'<Font ss:Bold="1" />');
 writeln (f,'</Style>');
 writeln (f,'<Style ss:ID="Borders" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">');
 writeln (f,'<Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:Indent="0" ss:WrapText="1" />');
 writeln (f,'<Borders>');
 writeln (f,'<Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'<Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'<Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'<Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'</Borders>');
 writeln (f,'<NumberFormat ss:Format="0.00_ ;[Red]\-0.00\ ;\ \-"/>');
 writeln (f,'</Style>');
 writeln (f,'<Style ss:ID="BordersBold" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">');
 writeln (f,'<Font ss:Bold="1" />');
 writeln (f,'<Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:Indent="0" ss:WrapText="1" />');
 writeln (f,'<Borders>');
 writeln (f,'<Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'<Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'<Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'<Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1" />');
 writeln (f,'</Borders>');
 writeln (f,'<NumberFormat ss:Format="0.00_ ;[Red]\-0.00\ ;\ \-"/>');
 writeln (f,'</Style>');
 writeln (f,'</Styles>');
//  1
 writeln (f,'<Worksheet ss:Name="" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">');
 writeln (f,'<Table x:FullColumns="1" x:FullRows="1" xmlns:x="urn:schemas-microsoft-com:office:excel">');
 writeln (f,'<Column ss:Width="600" />');
 //  
 write (f,'<Row><Cell ss:StyleID="Bold"><Data ss:Type="String">');
 write (f,'         ');
 writeln (f,'</Data></Cell></Row>');
 write (f,'<Row><Cell><Data ss:Type="String">');
 write (f,' VL:'+ProgramVersion+DebugBuild);
 writeln (f,'</Data></Cell></Row>');
 write (f,'<Row><Cell><Data ss:Type="String">');
 write (f,'    : '+DateToStr (Date)+' '+TimeToStr (Time));
 writeln (f,'</Data></Cell></Row>');
 write (f,'<Row><Cell ss:StyleID="Bold"><Data ss:Type="String">');
 write (f,'  :');
 writeln (f,'</Data></Cell></Row>');
 write (f,'<Row><Cell><Data ss:Type="String">');
 write (f,' : '+StrName);
 writeln (f,'</Data></Cell></Row>');
 write (f,'<Row><Cell><Data ss:Type="String">');
 write (f,'   : '+RegNumb);
 writeln (f,'</Data></Cell></Row>');
 write (f,'<Row><Cell ss:StyleID="Bold"><Data ss:Type="String">');
 write (f,'   .    :');
 writeln (f,'</Data></Cell></Row>');
 for i := 0 to Length (Recs) - 1
  do begin
      write (f,'<Row><Cell><Data ss:Type="String">');
      write (f,Recs [i].FileName+' ('+Recs [i].VidFormy+' '+Recs [i].SvedType+'  '+getPerName (Recs [i].Year,Recs [i].Per)+',  '+Recs [i].CatCode+')');
      writeln (f,'</Data></Cell></Row>');
     end;
 write (f,'<Row><Cell ss:StyleID="Bold"><Data ss:Type="String">');
 write (f,' :');
 writeln (f,'</Data></Cell></Row>');
 for i := 0 to Length (Periods) - 1
  do begin
      write (f,'<Row><Cell><Data ss:Type="String">');
      write (f,getPerName (Periods [i].Year,Periods [i].Quarter));
      writeln (f,'</Data></Cell></Row>');
     end;
 // ,   ,  
 if Log.Count > 0
  then begin
        write (f,'<Row><Cell><Data ss:Type="String">');
        write (f,'  ,   :');
        writeln (f,'</Data></Cell></Row>');
        for i := 0 to Log.Count - 1
         do begin
             write (f,'<Row><Cell><Data ss:Type="String">');
             write (f,Log.Strings [i]);
             writeln (f,'</Data></Cell></Row>');
            end;
       end;
 writeln (f,'</Table>');
 writeln (f,'</Worksheet>');
//  2
 writeln (f,'<Worksheet ss:Name="" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">');
 writeln (f,'<Table x:FullColumns="1" x:FullRows="1" xmlns:x="urn:schemas-microsoft-com:office:excel">');
 writeln (f,'<Column ss:Width="90" />');
 writeln (f,'<Column ss:Width="210" />');
 writeln (f,'<Column ss:Width="120" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 writeln (f,'<Column ss:Width="60" />');
 //  
 writeln (f,'<Row>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeDown="2"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeDown="2"><Data ss:Type="String">, , </Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeDown="2"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeDown="2"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeAcross="4"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeAcross="4"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'</Row>');
 writeln (f,'<Row>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:Index="5" ss:MergeAcross="1"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeAcross="2"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeAcross="1"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeAcross="2"><Data ss:Type="String"> </Data></Cell>');
 writeln (f,'</Row>');
 writeln (f,'<Row>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:Index="5"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'<Cell ss:StyleID="BordersBold"><Data ss:Type="String"></Data></Cell>');
 writeln (f,'</Row>');
 //  
 for i := 0 to Length (Sotrs)-1
  do begin
      writeln (f,'<Row>');
      write (f,'<Cell ss:StyleID="Borders" ss:MergeDown="' +IntToStr (Length (Periods)-1)+ '"><Data ss:Type="String">');
      write (f,Sotrs [i].StrNumb);
      writeln (f,'</Data></Cell>');
      write (f,'<Cell ss:StyleID="Borders" ss:MergeDown="' +IntToStr (Length (Periods)-1)+ '"><Data ss:Type="String">');
      write (f,Sotrs [i].SurName+' '+Sotrs [i].Name+' '+Sotrs [i].FatherName);
      writeln (f,'</Data></Cell>');
      NINS := 0;
      NIUS := 0;
      NINN := 0;
      NIUN := 0;
      for i1 := 0 to Length (Periods) - 1
       do begin
           GetNU (i,Periods [i1].Year,Periods [i1].Quarter,PackIndex,NS,NN,US,UN);
           NINS := NINS + NS;
           NIUS := NIUS + US;
           SS := NINS - NIUS;
           NINN := NINN + NN;
           NIUN := NIUN + UN;
           SN := NINN - NIUN;
           if PackIndex = '' then PackIndex := '-';
           if i1 > 0 then write (f,'<Row><Cell ss:StyleID="Borders" ss:Index="3">')
           else write (f,'<Cell ss:StyleID="Borders">');
           write (f,'<Data ss:Type="String">');
           write (f,getPerName (Periods [i1].Year,Periods [i1].Quarter));
           writeln (f,'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="String">');
           writeln (f,PackIndex+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (NS)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (US)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (NINS)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (NIUS)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (SS)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (NN)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (UN)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (NINN)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (NIUN)+'</Data></Cell>');
           write (f,'<Cell ss:StyleID="Borders"><Data ss:Type="Number">');
           writeln (f,f2s2 (SN)+'</Data></Cell>');
           writeln (f,'</Row>');
          end;
     end;
 // 
 i2 := Length (Periods) * Length (Sotrs);
 writeln (f,'<Row>');
 writeln (f,'<Cell ss:StyleID="BordersBold" ss:MergeDown="' +IntToStr (Length (Periods)-1)+ '" />');
 write (f,'<Cell ss:StyleID="BordersBold" ss:MergeDown="' +IntToStr (Length (Periods)-1)+ '"><Data ss:Type="String">');
 writeln (f,':</Data></Cell>');
 for i1 := 0 to Length (Periods) - 1
  do begin
      if i1 > 0 then write (f,'<Row><Cell ss:StyleID="BordersBold" ss:Index="3">')
      else write (f,'<Cell ss:StyleID="BordersBold">');
      write (f,'<Data ss:Type="String">');
      write (f,getPerName (Periods [i1].Year,Periods [i1].Quarter));
      writeln (f,'</Data></Cell>');
      writeln (f,'<Cell ss:StyleID="BordersBold" />');
      //
      writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=SUMIF(R[-'+IntToStr (i2+i1)+']C3:R[-'+IntToStr (1+i1)+']C3,RC3,R[-'+IntToStr (i2+i1)+']C:R[-'+IntToStr (1+i1)+']C)" />');
      writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=SUMIF(R[-'+IntToStr (i2+i1)+']C3:R[-'+IntToStr (1+i1)+']C3,RC3,R[-'+IntToStr (i2+i1)+']C:R[-'+IntToStr (1+i1)+']C)" />');
      if i1 > 0 then writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=R[-1]C+RC[-2]" />')
      else writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=RC[-2]" />');
      if i1 > 0 then writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=R[-1]C+RC[-2]" />')
      else writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=RC[-2]" />');
      writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=RC[-2]-RC[-1]" />');
      //
      writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=SUMIF(R[-'+IntToStr (i2+i1)+']C3:R[-'+IntToStr (1+i1)+']C3,RC3,R[-'+IntToStr (i2+i1)+']C:R[-'+IntToStr (1+i1)+']C)" />');
      writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=SUMIF(R[-'+IntToStr (i2+i1)+']C3:R[-'+IntToStr (1+i1)+']C3,RC3,R[-'+IntToStr (i2+i1)+']C:R[-'+IntToStr (1+i1)+']C)" />');
      if i1 > 0 then writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=R[-1]C+RC[-2]" />')
      else writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=RC[-2]" />');
      if i1 > 0 then writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=R[-1]C+RC[-2]" />')
      else writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=RC[-2]" />');
      writeln (f,'<Cell ss:StyleID="BordersBold" ss:Formula="=RC[-2]-RC[-1]" />');
      writeln (f,'</Row>');
     end;
 writeln (f,'</Table>');
//   
 writeln (f,' <AutoFilter x:Range="C3:C3"');
 writeln (f,'  xmlns="urn:schemas-microsoft-com:office:excel">');
 writeln (f,' </AutoFilter>');
 writeln (f,'</Worksheet>');
 //  
 writeln (f,'</Workbook>');
 CloseFile (f);
end;

procedure TConfig.Init;
begin
 FilesPath := '';
 PPPMethod := 0;
end;

procedure TConfig.Read;
var
 Reg : TRegistry;
begin
 Init;
 Reg := TRegistry.Create;
 if Reg.OpenKey (RegPath,True)
  then begin
        FilesPath := Reg.ReadString ('FilesPath');
        try
         PPPMethod := Reg.ReadInteger ('PPPMethod');
        except
         PPPMethod := 0;
        end;
        Reg.CloseKey;
       end
  else Save;
 Reg.Free;
end;

procedure TConfig.Save;
var
 Reg : TRegistry;
begin
 Reg := TRegistry.Create;
 Reg.OpenKey (RegPath,True);
 Reg.WriteString ('FilesPath',FilesPath);
 Reg.WriteInteger ('PPPMethod',PPPMethod);
 Reg.CloseKey;
 Reg.Free;
end;

constructor TSZV6Sotr.Create;
begin
 SetLength (NU,0);
end;

destructor TSZV6Sotr.Destroy;
begin
 SetLength (NU,0);
end;

end.
