unit mainform;

//       ,    
// Copyright (C) 2011  . .
//  

//            

//    http://www.kansoftware.ru/?tid=1741 ,   

interface

uses
 Windows,SysUtils,Classes,Controls,Forms,Dialogs,StdCtrls,ExtCtrls,ComCtrls,TabNotBk,Grids;

const
 VersionDate : string = '24  2011 .';
 DebugBuild  : Boolean = False;

type
 TMain_Form = class (TForm)
               Label1            : TLabel;
               Label2            : TLabel;
               Label3            : TLabel;
               OpenDialog        : TOpenDialog;
               EMail_Label       : TLabel;
               TabbedNotebook    : TTabbedNotebook;
               Label4            : TLabel;
               Path_Edit         : TEdit;
               Browse_Button     : TButton;
               GetStrList_Button : TButton;
               Label5            : TLabel;
               Process_Button    : TButton;
               Data_Grid         : TStringGrid;
               Group_Group       : TRadioGroup;
               Debug_Label       : TLabel;
               procedure Browse_ButtonClick (Sender: TObject);
               procedure GetStrList_ButtonClick (Sender: TObject);
               procedure Process_ButtonClick (Sender: TObject);
               procedure EMail_LabelClick (Sender: TObject);
               procedure OnShow (Sender: TObject);
               procedure OnClose (Sender: TObject; var Action: TCloseAction);
              private
               { Private declarations }
              public
               { Public declarations }
              end;

var
 Main_Form: TMain_Form;

implementation

{$R *.dfm}

uses ShellAPI,sverka,DirSelect;

type
  TFileVersionInfo = record
    FileType,
    CompanyName,
    FileDescription,
    FileVersion,
    InternalName,
    LegalCopyRight,
    LegalTradeMarks,
    OriginalFileName,
    ProductName,
    ProductVersion,
    Comments,
    SpecialBuildStr,
    PrivateBuildStr,
    FileFunction : string;
    PreRelease,
    SpecialBuild,
    PrivateBuild,
    Patched,
    InfoInferred : Boolean;
  end;

function FileVersionInfo (const sAppNamePath: TFileName): TFileVersionInfo;
var
 rSHFI: TSHFileInfo;
 iRet: Integer;
 VerSize: Integer;
 VerBuf: PChar;
 VerBufValue: Pointer;
 VerHandle: Cardinal;
 VerBufLen: Cardinal;
 VerKey: string;
 FixedFileInfo: PVSFixedFileInfo;

  // dwFileType, dwFileSubtype
  function GetFileSubType (FixedFileInfo: PVSFixedFileInfo) : string;
  begin
   case FixedFileInfo.dwFileType
    of
     VFT_UNKNOWN: Result := 'Unknown';
     VFT_APP: Result := 'Application';
     VFT_DLL: Result := 'DLL';
     VFT_STATIC_LIB: Result := 'Static-link Library';
     VFT_DRV:
        case FixedFileInfo.dwFileSubtype
         of
          VFT2_UNKNOWN: Result := 'Unknown Driver';
          VFT2_DRV_COMM: Result := 'Communications Driver';
          VFT2_DRV_PRINTER: Result := 'Printer Driver';
          VFT2_DRV_KEYBOARD: Result := 'Keyboard Driver';
          VFT2_DRV_LANGUAGE: Result := 'Language Driver';
          VFT2_DRV_DISPLAY: Result := 'Display Driver';
          VFT2_DRV_MOUSE: Result := 'Mouse Driver';
          VFT2_DRV_NETWORK: Result := 'Network Driver';
          VFT2_DRV_SYSTEM: Result := 'System Driver';
          VFT2_DRV_INSTALLABLE: Result := 'InstallableDriver';
          VFT2_DRV_SOUND: Result := 'Sound Driver';
         end;
     VFT_FONT:
        case FixedFileInfo.dwFileSubtype
         of
          VFT2_UNKNOWN: Result := 'Unknown Font';
          VFT2_FONT_RASTER: Result := 'Raster Font';
          VFT2_FONT_VECTOR: Result := 'Vector Font';
          VFT2_FONT_TRUETYPE: Result :='Truetype Font';
          else;
         end;
     VFT_VXD: Result :='Virtual Defice Identifier = ' + IntToHex (FixedFileInfo.dwFileSubtype,8);
    end;
  end;

  function HasdwFileFlags (FixedFileInfo: PVSFixedFileInfo; Flag : Word) : Boolean;
  begin
   Result := ((FixedFileInfo.dwFileFlagsMask and FixedFileInfo.dwFileFlags and Flag) = Flag);
  end;

  function GetFixedFileInfo: PVSFixedFileInfo;
  begin
   if not VerQueryValue (VerBuf,'',Pointer (Result),VerBufLen) then Result := nil;
  end;

  function GetInfo (const aKey: string): string;
  begin
   Result := '';
   VerKey := Format ('\StringFileInfo\%.4x%.4x\%s',[LoWord (Integer (VerBufValue^)),HiWord (Integer (VerBufValue^)),aKey]);
   if VerQueryValue (VerBuf,PChar (VerKey),VerBufValue,VerBufLen)
    then Result := StrPas (PChar (VerBufValue));
  end;

  function QueryValue (const aValue: string): string;
  begin
    Result := '';
    // obtain version information about the specified file
    if GetFileVersionInfo (PChar (sAppNamePath),VerHandle,VerSize,VerBuf) and
    // return selected version information
    VerQueryValue (VerBuf,'\VarFileInfo\Translation',VerBufValue,VerBufLen)
     then Result := GetInfo (aValue);
  end;


begin
 // Initialize the Result
 with Result
  do begin
      FileType := '';
      CompanyName := '';
      FileDescription := '';
      FileVersion := '';
      InternalName := '';
      LegalCopyRight := '';
      LegalTradeMarks := '';
      OriginalFileName := '';
      ProductName := '';
      ProductVersion := '';
      Comments := '';
      SpecialBuildStr:= '';
      PrivateBuildStr := '';
      FileFunction := '';
      Patched := False;
      PreRelease:= False;
      SpecialBuild:= False;
      PrivateBuild:= False;
      InfoInferred := False;
     end;

 // Get the file type
 if SHGetFileInfo (PChar (sAppNamePath),0,rSHFI,SizeOf (rSHFI),SHGFI_TYPENAME) <> 0
  then begin
        Result.FileType := rSHFI.szTypeName;
       end;
 iRet := SHGetFileInfo (PChar (sAppNamePath),0,rSHFI,SizeOf (rSHFI),SHGFI_EXETYPE);
 if iRet <> 0
  then begin
        // determine whether the OS can obtain version information
        VerSize := GetFileVersionInfoSize (PChar (sAppNamePath),VerHandle);
        if VerSize > 0
         then begin
               VerBuf := AllocMem (VerSize);
               try
                with Result
                 do begin
                     CompanyName := QueryValue ('CompanyName');
                     FileDescription := QueryValue ('FileDescription');
                     FileVersion := QueryValue ('FileVersion');
                     InternalName := QueryValue ('InternalName');
                     LegalCopyRight := QueryValue ('LegalCopyRight');
                     LegalTradeMarks := QueryValue ('LegalTradeMarks');
                     OriginalFileName := QueryValue ('OriginalFileName');
                     ProductName := QueryValue ('ProductName');
                     ProductVersion := QueryValue ('ProductVersion');
                     Comments := QueryValue ('Comments');
                     SpecialBuildStr := QueryValue ('SpecialBuild');
                     PrivateBuildStr := QueryValue ('PrivateBuild');
                     // Fill the  VS_FIXEDFILEINFO structure
                     FixedFileInfo := GetFixedFileInfo;
                     PreRelease := HasdwFileFlags (FixedFileInfo,VS_FF_PRERELEASE);
                     PrivateBuild := HasdwFileFlags (FixedFileInfo,VS_FF_PRIVATEBUILD);
                     SpecialBuild := HasdwFileFlags (FixedFileInfo,VS_FF_SPECIALBUILD);
                     Patched := HasdwFileFlags (FixedFileInfo,VS_FF_PATCHED);
                     InfoInferred := HasdwFileFlags (FixedFileInfo,VS_FF_INFOINFERRED);
                     FileFunction := GetFileSubType (FixedFileInfo);
                    end;
               finally
                FreeMem (VerBuf,VerSize);
               end;
              end;
       end;
end;

//  
procedure TMain_Form.Browse_ButtonClick (Sender: TObject);
var
 s : string;
begin
 // if OpenDialog.Execute then Path_Edit.Text := ExtractFilePath (OpenDialog.FileName);
 s := SelFolder (Handle);
 if s <> '' then Path_Edit.Text := s;
end;

//   
procedure TMain_Form.EMail_LabelClick (Sender: TObject);
begin
 ShellExecute (0,'open',PChar (EMail_Label.Caption),'','',sw_maximize);
end;

procedure TMain_Form.GetStrList_ButtonClick (Sender: TObject);
var
 NL,UL : TStringList;
 i     : integer;
begin
 NL := TStringList.Create;
 UL := TStringList.Create;
 getNumList (Path_Edit.Text+'\',NL,UL);
 if NL.Count=0
  then MessageBox (Handle,'  .   .','',mb_IconError)
  else begin
        Data_Grid.ColCount := 2;
        Data_Grid.RowCount := 1;
        with Data_Grid.Rows [0]
         do begin
             Clear;
             Add ('.   ');
             Add (' ');
            end;
        for i := 0 to NL.Count - 1
         do begin
             Data_Grid.RowCount := Data_Grid.RowCount + 1;
             with Data_Grid.Rows [Data_Grid.RowCount - 1]
              do begin
                  Clear;
                  Add (UL.Strings [i]);
                  Add (NL.Strings [i]);
                 end;
            end;
        Data_Grid.FixedRows := 1;
        TabbedNotebook.PageIndex := 1;
       end;
 NL.Free;
 UL.Free;
end;

procedure TMain_Form.OnClose (Sender: TObject; var Action: TCloseAction);
begin
 Config.FilesPath := Path_Edit.Text;
 Config.PPPMethod := Group_Group.ItemIndex;
 Config.Save;
end;

procedure TMain_Form.OnShow (Sender: TObject);
var
 FvI: TFileVersionInfo;
begin
 Config.Read;
 OpenDialog.InitialDir := Config.FilesPath;
 Group_Group.ItemIndex := Config.PPPMethod;
 FvI := FileVersionInfo (Application.ExeName);
 Label2.Caption := ' '+FvI.ProductVersion+'  '+ VersionDate;
 if DebugBuild then Debug_Label.Caption := '    .';
 TabbedNotebook.PageIndex := 0;
end;

procedure TMain_Form.Process_ButtonClick (Sender: TObject);
var
 f      : TFileSet;
 Log    : TStringList;
 i      : integer;
 fname  : string;
begin
 //  
 if Data_Grid.Row < 1 then MessageBox (Handle,' ','',mb_IconInformation+mb_OK)
 else if Data_Grid.Cells [0,Data_Grid.Row] = ''
  then begin
        MessageBox (Handle,'  .','',mb_IconInformation+mb_OK);
        TabbedNotebook.PageIndex := 0;
       end
 else begin
       //  
       Log := TStringList.Create;
       f := TFileSet.Create;
       //  
       f.Get (Path_Edit.Text+'\',Data_Grid.Cells [0,Data_Grid.Row],Log);
       if Length (f.Sotrs) = 0 then MessageBox (Handle,'     .','',mb_IconError)
       else begin
             //  HTML
             if Group_Group.ItemIndex = 2
             then begin
             fname := GetEnvironmentVariable ('TEMP')+'\'+ Data_Grid.Cells [0,Data_Grid.Row]+'.xls';
             f.makeXLS (Log,Label2.Caption,Debug_Label.Caption,EMail_Label.Caption,Data_Grid.Cells [1,Data_Grid.Row],Data_Grid.Cells [0,Data_Grid.Row],fname,0);
             end
             else begin
             fname := GetEnvironmentVariable ('TEMP')+'\'+ Data_Grid.Cells [0,Data_Grid.Row]+'.html';
             f.makeHTML (Log,Label2.Caption,Debug_Label.Caption,EMail_Label.Caption,Data_Grid.Cells [1,Data_Grid.Row],Data_Grid.Cells [0,Data_Grid.Row],fname,Group_Group.ItemIndex);
             end;
             //  
             ShellExecute (0,'open',PChar (fname),'','',sw_maximize);
            end;
       // 
       f.Destroy;
       Log.Free;
      end;
end;

end.
